/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.dstu3;

import ca.uhn.fhir.repository.IRepository;
import java.util.Arrays;
import java.util.List;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.RelatedArtifact;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.adapter.IAdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.IKnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.dstu3.SearchHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageHelper
extends org.opencds.cqf.fhir.utility.PackageHelper {
    protected static final Logger logger = LoggerFactory.getLogger(PackageHelper.class);
    protected static final List<String> PACKABLE_RESOURCES = Arrays.asList(Enumerations.FHIRAllTypes.LIBRARY.toCode(), Enumerations.FHIRAllTypes.PLANDEFINITION.toCode(), Enumerations.FHIRAllTypes.ACTIVITYDEFINITION.toCode(), Enumerations.FHIRAllTypes.STRUCTUREDEFINITION.toCode(), Enumerations.FHIRAllTypes.CODESYSTEM.toCode(), Enumerations.FHIRAllTypes.VALUESET.toCode());

    private PackageHelper() {
    }

    public static void addRelatedArtifacts(IBaseBundle bundle, List<RelatedArtifact> artifacts, IRepository repository, boolean isPut) {
        for (RelatedArtifact artifact : artifacts) {
            if (!artifact.getType().equals((Object)RelatedArtifact.RelatedArtifactType.DEPENDSON) || !artifact.hasResource()) continue;
            try {
                Resource resource;
                String canonical = artifact.getResource().getReference();
                if (!PACKABLE_RESOURCES.contains(Canonicals.getResourceType(canonical)) || (resource = SearchHelper.searchRepositoryByCanonical(repository, new StringType(canonical))) == null || !BundleHelper.getEntryResources(bundle).stream().noneMatch(r -> r.getIdElement().equals((Object)resource.getIdElement()))) continue;
                BundleHelper.addEntry(bundle, PackageHelper.createEntry((IBaseResource)resource, isPut));
                IKnowledgeArtifactAdapter adapter = IAdapterFactory.forFhirVersion(resource.getStructureFhirVersionEnum()).createKnowledgeArtifactAdapter((IDomainResource)resource);
                if (!adapter.hasRelatedArtifact()) continue;
                PackageHelper.addRelatedArtifacts(bundle, adapter.getRelatedArtifact(), repository, isPut);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

