/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.matcher;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.TokenParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseEnumeration;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Timing;
import org.opencds.cqf.fhir.utility.FhirPathCache;
import org.opencds.cqf.fhir.utility.matcher.ResourceMatcher;

public class ResourceMatcherR4
implements ResourceMatcher {
    private Map<ResourceMatcher.SPPathKey, IFhirPath.IParsedExpression> pathCache = new HashMap<ResourceMatcher.SPPathKey, IFhirPath.IParsedExpression>();
    private Map<String, RuntimeSearchParam> searchParams = new HashMap<String, RuntimeSearchParam>();

    @Override
    public IFhirPath getEngine() {
        return FhirPathCache.cachedForVersion(FhirVersionEnum.R4);
    }

    @Override
    public FhirContext getContext() {
        return FhirContext.forR4Cached();
    }

    @Override
    public DateRangeParam getDateRange(ICompositeType type) {
        if (type instanceof Period) {
            Period period = (Period)type;
            return new DateRangeParam(period.getStart(), period.getEnd());
        }
        if (type instanceof Timing) {
            throw new NotImplementedException("Timing resolution has not yet been implemented");
        }
        throw new UnsupportedOperationException("Expected element of type Period or Timing, found " + type.getClass().getSimpleName());
    }

    @Override
    public List<TokenParam> getCodes(IBase codeElement) {
        List<Object> resolvedCodes = new ArrayList<TokenParam>();
        if (codeElement instanceof Coding) {
            Coding c = (Coding)codeElement;
            resolvedCodes.add(new TokenParam(c.getSystem(), c.getCode()));
        } else if (codeElement instanceof CodeType) {
            CodeType c = (CodeType)codeElement;
            resolvedCodes.add(new TokenParam((String)c.getValue()));
        } else if (codeElement instanceof CodeableConcept) {
            CodeableConcept concept = (CodeableConcept)codeElement;
            resolvedCodes = concept.getCoding().stream().map(code -> new TokenParam(code.getSystem(), code.getCode())).collect(Collectors.toList());
        }
        return resolvedCodes;
    }

    @Override
    public Map<ResourceMatcher.SPPathKey, IFhirPath.IParsedExpression> getPathCache() {
        return this.pathCache;
    }

    @Override
    public boolean isMatchToken(TokenParam param, IBase pathResult) {
        if (param.getValue() == null) {
            return true;
        }
        if (pathResult instanceof IIdType) {
            IIdType id = (IIdType)pathResult;
            return param.getValue().equals(id.getIdPart());
        }
        if (pathResult instanceof Identifier) {
            Identifier identifier = (Identifier)pathResult;
            String system = identifier.getSystem();
            String value = identifier.getValue();
            if (param.getSystem() != null && param.getSystem().equals(system) && param.getValue() != null && param.getValue().equals(value)) {
                return true;
            }
            if (param.getValue() != null && param.getValue().equals(value)) {
                return true;
            }
            return param.getSystem() != null && param.getSystem().equals(system);
        }
        if (pathResult instanceof IBaseEnumeration) {
            IBaseEnumeration enumeration = (IBaseEnumeration)pathResult;
            return param.getValue().equals(enumeration.getValueAsString());
        }
        if (pathResult instanceof IPrimitiveType) {
            IPrimitiveType type = (IPrimitiveType)pathResult;
            return param.getValue().equals(type.getValue());
        }
        return false;
    }

    @Override
    public void addCustomParameter(RuntimeSearchParam searchParam) {
        this.searchParams.put(searchParam.getName(), searchParam);
    }

    @Override
    public Map<String, RuntimeSearchParam> getCustomParameters() {
        return this.searchParams;
    }
}

