/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.model;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeChildPrimitiveEnumerationDatatypeDefinition;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseElement;
import org.hl7.fhir.instance.model.api.IBaseEnumFactory;
import org.hl7.fhir.instance.model.api.IBaseEnumeration;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.StringType;
import org.opencds.cqf.cql.engine.fhir.exception.UnknownType;
import org.opencds.cqf.cql.engine.fhir.model.FhirModelResolver;
import org.opencds.cqf.cql.engine.model.CachingModelResolverDecorator;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicModelResolver
extends CachingModelResolverDecorator {
    protected static final Logger logger = LoggerFactory.getLogger(DynamicModelResolver.class);
    private static final String CANONICAL = "CanonicalType";
    private static final String CODE = "Code";
    private static final String CODEABLECONCEPT = "CodeableConcept";
    private static final String ENUMERATION = "Enumeration";
    private static final String PRIMITIVE = "IPrimitiveType";
    private static final String URI = "UriType";
    private final FhirContext fhirContext;

    public DynamicModelResolver(ModelResolver modelResolver) {
        super(modelResolver);
        this.fhirContext = ((FhirModelResolver)modelResolver).getFhirContext();
    }

    public DynamicModelResolver(ModelResolver modelResolver, FhirContext fhirContext) {
        super(modelResolver);
        this.fhirContext = fhirContext;
    }

    public Object resolvePath(Object target, String path) {
        Object pathResult = null;
        try {
            pathResult = super.resolvePath(target, path);
        }
        catch (Exception e) {
            logger.error("Error encountered resolving path: %s".formatted(path), (Throwable)e);
        }
        return pathResult;
    }

    public Object as(Object value, Class<?> type, boolean isStrict) {
        org.hl7.fhir.dstu3.model.Coding coding;
        org.hl7.fhir.dstu3.model.StringType stringType;
        if (value instanceof org.hl7.fhir.dstu3.model.StringType) {
            stringType = (org.hl7.fhir.dstu3.model.StringType)value;
            switch (type.getSimpleName()) {
                case "CodeableConcept": {
                    return stringType.castToCodeableConcept((org.hl7.fhir.dstu3.model.Base)stringType.castToCode((org.hl7.fhir.dstu3.model.Base)stringType));
                }
                case "UriType": {
                    return stringType.castToUri((org.hl7.fhir.dstu3.model.Base)stringType);
                }
            }
        }
        if (value instanceof org.hl7.fhir.dstu3.model.Coding) {
            coding = (org.hl7.fhir.dstu3.model.Coding)value;
            switch (type.getSimpleName()) {
                case "Code": 
                case "IPrimitiveType": {
                    return coding.getCodeElement();
                }
            }
        }
        if (value instanceof org.hl7.fhir.r4.model.StringType) {
            stringType = (org.hl7.fhir.r4.model.StringType)value;
            switch (type.getSimpleName()) {
                case "CodeableConcept": {
                    return stringType.castToCodeableConcept((Base)stringType.castToCode((Base)stringType));
                }
                case "CanonicalType": {
                    return stringType.castToCanonical((Base)stringType);
                }
            }
        }
        if (value instanceof org.hl7.fhir.r4.model.Coding) {
            coding = (org.hl7.fhir.r4.model.Coding)value;
            switch (type.getSimpleName()) {
                case "Code": 
                case "IPrimitiveType": {
                    return coding.getCodeElement();
                }
            }
        }
        if (value instanceof StringType) {
            stringType = (StringType)value;
            switch (type.getSimpleName()) {
                case "CodeableConcept": {
                    return new CodeableConcept(new Coding(null, stringType.asStringValue(), null));
                }
                case "CanonicalType": {
                    return new CanonicalType(stringType.asStringValue());
                }
            }
        }
        if (value instanceof Coding) {
            coding = (Coding)value;
            switch (type.getSimpleName()) {
                case "Code": 
                case "IPrimitiveType": {
                    return coding.getCodeElement();
                }
            }
        }
        return super.as(value, type, isStrict);
    }

    public void setValue(Object target, String path, Object value) {
        IBase base;
        if (target == null) {
            return;
        }
        if (target instanceof IBaseEnumeration) {
            IBaseEnumeration enumeration = (IBaseEnumeration)target;
            if (path.equals("value")) {
                enumeration.setValueAsString((String)value);
                return;
            }
        }
        if ((base = (IBase)target) instanceof IPrimitiveType) {
            IPrimitiveType type = (IPrimitiveType)base;
            ((FhirModelResolver)this.getInnerResolver()).setPrimitiveValue(value, type);
            return;
        }
        BaseRuntimeElementCompositeDefinition definition = this.resolveRuntimeDefinition(base);
        if (path.contains(".")) {
            this.setNestedValue((IBase)target, path, value, definition);
        } else {
            BaseRuntimeElementDefinition elementDef;
            BaseRuntimeChildDefinition childDef;
            if (!path.contains("[x]") && (childDef = definition.getChildByName(path)) != null && (elementDef = childDef.getChildByName(path)) != null && elementDef.getImplementingClass().getSimpleName().equals(ENUMERATION) && value != null && !value.getClass().getSimpleName().equals(ENUMERATION)) {
                value = this.getEnumValue((RuntimeChildPrimitiveEnumerationDatatypeDefinition)childDef, ((IPrimitiveType)this.as(value, IPrimitiveType.class, false)).getValueAsString());
            }
            super.setValue(target, path, value);
        }
    }

    protected <T extends IBase> BaseRuntimeElementCompositeDefinition<T> resolveRuntimeDefinition(IBase base) {
        if (base instanceof IAnyResource) {
            IAnyResource resource = (IAnyResource)base;
            return this.fhirContext.getResourceDefinition((IBaseResource)resource);
        }
        if (base instanceof IBaseBackboneElement || base instanceof IBaseElement) {
            return (BaseRuntimeElementCompositeDefinition)this.fhirContext.getElementDefinition(base.getClass());
        }
        if (base instanceof ICompositeType) {
            return (BaseRuntimeElementCompositeDefinition)this.fhirContext.getElementDefinition(base.getClass());
        }
        throw new UnknownType("Unable to resolve the runtime definition for %s".formatted(base.getClass().getName()));
    }

    public void setNestedValue(IBase target, String path, Object value, BaseRuntimeElementCompositeDefinition<?> def) {
        String[] identifiers = path.split("\\.");
        for (int i = 0; i < identifiers.length; ++i) {
            String identifier = identifiers[i];
            boolean isList = identifier.contains("[");
            boolean isSlice = identifier.contains(":");
            String sliceName = isSlice ? identifier.split(":")[1] : null;
            boolean isLast = i == identifiers.length - 1;
            int index = isList ? Character.getNumericValue(identifier.charAt(identifier.indexOf("[") + 1)) : 0;
            String targetPath = this.getTargetPath(identifier, isList, isSlice);
            BaseRuntimeChildDefinition targetDef = def.getChildByName(targetPath);
            List targetValues = targetDef.getAccessor().getValues(target);
            IBase targetValue = targetValues.size() >= index + 1 && !isLast ? this.getTargetValueFromList(sliceName, index, targetValues) : this.getTargetValue(target, value, isLast, targetPath, targetDef);
            IBase iBase = target = targetValue == null ? target : targetValue;
            if (isLast) continue;
            BaseRuntimeElementDefinition nextDef = this.fhirContext.getElementDefinition(target.getClass());
            def = (BaseRuntimeElementCompositeDefinition)nextDef;
        }
    }

    private String getTargetPath(String identifier, boolean isList, boolean isSlice) {
        if (isList) {
            return identifier.replaceAll("\\[\\d\\]", "");
        }
        if (isSlice) {
            return identifier.substring(0, identifier.indexOf(":"));
        }
        return identifier;
    }

    private IBase getTargetValue(IBase target, Object value, boolean isLast, String targetPath, BaseRuntimeChildDefinition targetDef) {
        Class elementClass;
        BaseRuntimeElementDefinition elementDef = targetDef.getChildByName(targetPath);
        Object targetValue = isLast ? ((elementClass = elementDef.getImplementingClass()).getSimpleName().equals(ENUMERATION) ? this.getEnumValue((RuntimeChildPrimitiveEnumerationDatatypeDefinition)targetDef, ((IPrimitiveType)this.as(value, IPrimitiveType.class, false)).getValueAsString()) : (IBase)this.as(value, elementClass, false)) : elementDef.newInstance(targetDef.getInstanceConstructorArguments());
        if (targetValue != null) {
            targetDef.getMutator().addValue(target, targetValue);
        }
        return targetValue;
    }

    private IBase getTargetValueFromList(String sliceName, int index, List<IBase> targetValues) {
        IBase targetValue = targetValues.size() > 1 && StringUtils.isNotBlank((CharSequence)sliceName) ? targetValues.get(0) : targetValues.get(index);
        return targetValue;
    }

    private <T extends Enum<?>, E extends IBaseEnumeration<T>> E getEnumValue(RuntimeChildPrimitiveEnumerationDatatypeDefinition targetDef, String value) {
        switch (this.fhirContext.getVersion().getVersion()) {
            case DSTU3: {
                return (E)new org.hl7.fhir.dstu3.model.Enumeration((org.hl7.fhir.dstu3.model.EnumFactory)DynamicModelResolver.toEnumFactory(targetDef.getBoundEnumType()), value);
            }
            case R4: {
                return (E)new Enumeration((EnumFactory)DynamicModelResolver.toEnumFactory(targetDef.getBoundEnumType()), value);
            }
            case R5: {
                return (E)new org.hl7.fhir.r5.model.Enumeration((org.hl7.fhir.r5.model.EnumFactory)DynamicModelResolver.toEnumFactory(targetDef.getBoundEnumType()), value);
            }
        }
        return null;
    }

    static <E extends IBaseEnumFactory<?>> E toEnumFactory(Class<?> enumerationType) {
        IBaseEnumFactory retVal;
        String className = enumerationType.getName() + "EnumFactory";
        try {
            Class<?> clazz = Class.forName(className);
            retVal = (IBaseEnumFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new UnknownType("Failed to instantiate %s".formatted(className));
        }
        return (E)retVal;
    }
}

