/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.model;

import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import org.opencds.cqf.cql.engine.fhir.model.Dstu2FhirModelResolver;
import org.opencds.cqf.cql.engine.fhir.model.Dstu3FhirModelResolver;
import org.opencds.cqf.cql.engine.fhir.model.R4FhirModelResolver;
import org.opencds.cqf.cql.engine.fhir.model.R5FhirModelResolver;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.utility.model.DynamicModelResolver;

public class FhirModelResolverCache {
    private static Map<FhirVersionEnum, ModelResolver> cache = new EnumMap<FhirVersionEnum, ModelResolver>(FhirVersionEnum.class);

    private FhirModelResolverCache() {
    }

    public static ModelResolver resolverForVersion(FhirVersionEnum fhirVersionEnum) {
        Objects.requireNonNull(fhirVersionEnum, "fhirVersionEnum can not be null");
        if (!cache.containsKey(fhirVersionEnum)) {
            DynamicModelResolver resolver = null;
            switch (fhirVersionEnum) {
                case DSTU2: {
                    resolver = new DynamicModelResolver((ModelResolver)new Dstu2FhirModelResolver());
                    break;
                }
                case DSTU3: {
                    resolver = new DynamicModelResolver((ModelResolver)new Dstu3FhirModelResolver());
                    break;
                }
                case R4: {
                    resolver = new DynamicModelResolver((ModelResolver)new R4FhirModelResolver());
                    break;
                }
                case R5: {
                    resolver = new DynamicModelResolver((ModelResolver)new R5FhirModelResolver());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown or unsupported FHIR version");
                }
            }
            cache.put(fhirVersionEnum, (ModelResolver)resolver);
        }
        return cache.get(fhirVersionEnum);
    }
}

