/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.monad;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.opencds.cqf.fhir.utility.monad.Eithers;

public class Either3<L, M, R> {
    private final L left;
    private final M middle;
    private final R right;

    Either3(L left, M middle, R right) {
        Preconditions.checkArgument((boolean)(left != null ^ middle != null ^ right != null), (Object)"left, middle, and right are mutually exclusive");
        this.left = left;
        this.middle = middle;
        this.right = right;
    }

    public Either3<R, M, L> swap() {
        if (this.isRight()) {
            return Eithers.forLeft3(this.right);
        }
        if (this.isMiddle()) {
            return Eithers.forMiddle3(this.middle);
        }
        return Eithers.forRight3(this.left);
    }

    public Either3<R, L, M> rotate() {
        if (this.isRight()) {
            return Eithers.forLeft3(this.right);
        }
        if (this.isMiddle()) {
            return Eithers.forRight3(this.middle);
        }
        return Eithers.forMiddle3(this.left);
    }

    public L leftOrThrow() {
        Preconditions.checkState((boolean)this.isLeft());
        return this.left;
    }

    public M middleOrThrow() {
        Preconditions.checkState((boolean)this.isMiddle());
        return this.middle;
    }

    public R rightOrThrow() {
        Preconditions.checkState((boolean)this.isRight());
        return this.right;
    }

    public R getOrThrow() {
        return this.rightOrThrow();
    }

    public R orElse(R defaultValue) {
        if (this.isRight()) {
            return this.right;
        }
        return defaultValue;
    }

    public R orElseGet(Supplier<R> defaultSupplier) {
        if (this.isRight()) {
            return this.right;
        }
        return defaultSupplier.get();
    }

    public boolean isLeft() {
        return this.left != null;
    }

    public boolean isMiddle() {
        return this.middle != null;
    }

    public boolean isRight() {
        return this.right != null;
    }

    public void forEach(Consumer<? super R> forRight) {
        Preconditions.checkNotNull(forRight);
        if (this.isRight()) {
            forRight.accept(this.right);
        }
    }

    public Either3<L, M, R> peek(Consumer<? super R> forRight) {
        Preconditions.checkNotNull(forRight);
        if (this.isRight()) {
            forRight.accept(this.right);
        }
        return this;
    }

    public <T> Either3<L, M, T> map(Function<? super R, ? extends T> mapRight) {
        Preconditions.checkNotNull(mapRight);
        if (this.isRight()) {
            return Eithers.forRight3(mapRight.apply(this.right));
        }
        return this.propagate();
    }

    public <T> Either3<L, M, T> flatMap(Function<? super R, ? extends Either3<L, M, ? extends T>> flatMapRight) {
        Preconditions.checkNotNull(flatMapRight);
        if (this.isRight()) {
            return this.narrow(flatMapRight.apply(this.right));
        }
        return this.propagate();
    }

    public <T> T fold(Function<? super L, ? extends T> foldLeft, Function<? super M, ? extends T> foldMiddle, Function<? super R, ? extends T> foldRight) {
        Preconditions.checkNotNull(foldLeft);
        Preconditions.checkNotNull(foldMiddle);
        Preconditions.checkNotNull(foldRight);
        if (this.isRight()) {
            return foldRight.apply(this.right);
        }
        if (this.isMiddle()) {
            return foldMiddle.apply(this.middle);
        }
        return foldLeft.apply(this.left);
    }

    public <U> U transform(Function<? super Either3<? super L, ? super M, ? super R>, ? extends U> transform) {
        return transform.apply(this);
    }

    public Stream<R> stream() {
        if (this.isRight()) {
            return Stream.of(this.right);
        }
        return Stream.of(new Object[0]);
    }

    public Optional<R> optional() {
        if (this.isRight()) {
            return Optional.of(this.right);
        }
        return Optional.empty();
    }

    protected <T> Either3<L, M, T> narrow(Either3<L, M, ? extends T> wide) {
        return wide;
    }

    protected <T> Either3<L, M, T> propagate() {
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Either3) {
            Either3 other = (Either3)obj;
            return this.left == other.left && this.right == other.right && this.middle == other.middle || this.left != null && other.left != null && this.left.equals(other.left) || this.middle != null && other.middle != null && this.middle.equals(other.middle) || this.right != null && other.right != null && this.right.equals(other.right);
        }
        return false;
    }

    public int hashCode() {
        if (this.left != null) {
            return this.left.hashCode();
        }
        if (this.middle != null) {
            return this.middle.hashCode();
        }
        return this.right.hashCode();
    }
}

