/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.operation;

import ca.uhn.fhir.repository.IRepository;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.fhir.utility.operation.InvocationContext;
import org.opencds.cqf.fhir.utility.operation.MethodBinder;
import org.opencds.cqf.fhir.utility.operation.Scope;

public class OperationRegistry {
    private final Multimap<String, InvocationContext<?>> invocationContextByName = MultimapBuilder.hashKeys().arrayListValues().build();

    public <T> void register(Class<T> clazz, Function<IRepository, T> factory) {
        List methodBinders = Arrays.stream(clazz.getMethods()).filter(m -> m.isAnnotationPresent(Operation.class)).map(MethodBinder::new).collect(Collectors.toList());
        if (methodBinders.isEmpty()) {
            throw new IllegalArgumentException("No operations found on class " + clazz.getName());
        }
        for (MethodBinder methodBinder : methodBinders) {
            InvocationContext<T> context = new InvocationContext<T>(factory, methodBinder);
            this.invocationContextByName.put((Object)methodBinder.name(), context);
        }
    }

    public OperationInvocationParams buildInvocationContext(IRepository repository, String operationName) {
        return new OperationInvocationParams(repository, operationName);
    }

    IBaseResource execute(OperationInvocationParams params) throws Exception {
        Objects.requireNonNull(params, "Operation invocation parameters cannot be null");
        InvocationContext<?> context = this.findInvocationContext(params.scope(), params.name(), params.typeName());
        Object instance = context.factory().apply(params.repository());
        Callable<IBaseResource> callable = context.methodBinder().bind(instance, params.id(), params.parameters());
        return callable.call();
    }

    private static String normalizeName(String name) {
        return name.startsWith("$") ? name.substring(1) : name;
    }

    private InvocationContext<?> findInvocationContext(Scope scope, String name, String typeName) {
        Objects.requireNonNull(scope, "scope cannot be null");
        Objects.requireNonNull(name, "operation name cannot be null");
        Objects.requireNonNull(typeName, "typeName cannot be null");
        String normalizedName = OperationRegistry.normalizeName(name);
        Collection contexts = this.invocationContextByName.get((Object)normalizedName);
        if (contexts.isEmpty()) {
            throw new InvalidRequestException("No operation found with name " + normalizedName);
        }
        List scopedContexts = contexts.stream().filter(c -> c.methodBinder().scope() == scope).collect(Collectors.toList());
        if (scopedContexts.isEmpty()) {
            throw new InvalidRequestException("No operation found with name " + normalizedName + " and scope " + String.valueOf((Object)scope));
        }
        Predicate<InvocationContext> typePredicate = typeName.isEmpty() ? c -> true : c -> c.methodBinder().typeName().equals(typeName);
        List typeContexts = scopedContexts.stream().filter(typePredicate).collect(Collectors.toList());
        if (typeContexts.isEmpty()) {
            throw new InvalidRequestException("No operation found with type " + typeName);
        }
        if (typeContexts.size() > 1) {
            throw new IllegalStateException("Multiple operations found with name " + normalizedName + " and type " + typeName);
        }
        return (InvocationContext)typeContexts.get(0);
    }

    public class OperationInvocationParams {
        private final IRepository repository;
        private final String name;
        private IBaseParameters parameters;
        private IIdType id;
        private Class<? extends IBaseResource> resourceType;

        OperationInvocationParams(IRepository repository, String name) {
            this.repository = Objects.requireNonNull(repository, "Repository cannot be null");
            this.name = Objects.requireNonNull(name, "Operation name cannot be null");
        }

        public IRepository repository() {
            return this.repository;
        }

        public OperationInvocationParams id(IIdType id) {
            this.id = id;
            return this;
        }

        public IIdType id() {
            return this.id;
        }

        public String name() {
            return this.name;
        }

        public IBaseParameters parameters() {
            return this.parameters;
        }

        public OperationInvocationParams parameters(IBaseParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public OperationInvocationParams resourceType(Class<? extends IBaseResource> resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        Scope scope() {
            if (this.id != null) {
                return Scope.INSTANCE;
            }
            if (this.resourceType != null) {
                return Scope.TYPE;
            }
            return Scope.SERVER;
        }

        String typeName() {
            if (this.resourceType != null) {
                return this.resourceType.getSimpleName();
            }
            if (this.id != null) {
                return this.id.getResourceType();
            }
            return "";
        }

        public IBaseResource execute() throws Exception, Throwable {
            try {
                return OperationRegistry.this.execute(this);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
    }
}

