/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.repository;

import ca.uhn.fhir.context.FhirContext;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.opencds.cqf.fhir.utility.repository.ResourceLoader;
import org.opencds.cqf.fhir.utility.repository.ig.CqlContent;

public class FhirResourceLoader
implements ResourceLoader {
    List<IBaseResource> resources;
    FhirContext fhirContext;
    Class<?> relativeToClazz;

    public FhirResourceLoader(FhirContext context, Class<?> clazz, List<String> directoryList, boolean recursive) {
        this.fhirContext = context;
        this.relativeToClazz = clazz;
        this.resources = directoryList.stream().map(this::getDirectoryOrFileLocation).filter(x -> x != null).map(x -> this.getFilePaths((String)x, recursive)).flatMap(Collection::stream).map(this::loadTestResources).toList();
    }

    @Override
    public Class<?> getRelativeClass() {
        return this.relativeToClazz;
    }

    public List<IBaseResource> getResources() {
        return this.resources;
    }

    private String getDirectoryOrFileLocation(String relativePath) {
        URL resource = this.relativeToClazz.getResource(relativePath);
        if (resource == null) {
            return null;
        }
        String directoryLocationUrl = resource.toString();
        if (directoryLocationUrl.startsWith("file:/")) {
            directoryLocationUrl = directoryLocationUrl.substring("file:/".length() - 1);
        }
        return directoryLocationUrl;
    }

    private List<String> getFilePaths(String directoryPath, boolean recursive) {
        ArrayList<String> filePaths = new ArrayList<String>();
        File inputDir = new File(directoryPath);
        ArrayList<File> files = inputDir.isDirectory() ? new ArrayList<File>(Arrays.asList(Optional.ofNullable(inputDir.listFiles()).orElseThrow(NoSuchElementException::new))) : new ArrayList();
        for (File file : files) {
            if (file.isDirectory()) {
                if (!recursive) continue;
                filePaths.addAll(this.getFilePaths(file.getPath(), recursive));
                continue;
            }
            if (file.getPath().endsWith(".cql")) continue;
            filePaths.add(file.getPath());
        }
        return filePaths;
    }

    private IBaseResource loadTestResources(String location) {
        Path path = Path.of(location, new String[0]);
        IBaseResource resource = this.readResource(this.fhirContext, location);
        CqlContent.loadCqlContent(resource, path.getParent());
        return resource;
    }
}

