/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.repository;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.repository.IRepository;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import org.apache.commons.lang3.NotImplementedException;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Endpoint;
import org.opencds.cqf.fhir.utility.client.Clients;
import org.opencds.cqf.fhir.utility.matcher.ResourceMatcher;
import org.opencds.cqf.fhir.utility.matcher.ResourceMatcherDSTU3;
import org.opencds.cqf.fhir.utility.matcher.ResourceMatcherR4;
import org.opencds.cqf.fhir.utility.matcher.ResourceMatcherR5;
import org.opencds.cqf.fhir.utility.repository.ProxyRepository;
import org.opencds.cqf.fhir.utility.repository.RestRepository;

public class Repositories {
    private Repositories() {
    }

    public static ProxyRepository proxy(IRepository data, IRepository content, IRepository terminology) {
        return new ProxyRepository(data, content, terminology);
    }

    private static IGenericClient createClient(FhirContext fhirContext, IBaseResource endpoint) {
        FhirVersionEnum fhirVersion = fhirContext.getVersion().getVersion();
        return switch (fhirVersion) {
            case FhirVersionEnum.DSTU3 -> Clients.forEndpoint(fhirContext, (org.hl7.fhir.dstu3.model.Endpoint)endpoint);
            case FhirVersionEnum.R4 -> Clients.forEndpoint(fhirContext, (Endpoint)endpoint);
            case FhirVersionEnum.R5 -> Clients.forEndpoint(fhirContext, (org.hl7.fhir.r5.model.Endpoint)endpoint);
            default -> throw new IllegalArgumentException("unsupported FHIR version: %s".formatted(fhirVersion.getFhirVersionString()));
        };
    }

    public static IRepository createRestRepository(FhirContext fhirContext, IBaseResource endpoint) {
        return endpoint == null ? null : new RestRepository(Repositories.createClient(fhirContext, endpoint));
    }

    public static IRepository proxy(IRepository localRepository, Boolean useLocalData, IBaseResource dataEndpoint, IBaseResource contentEndpoint, IBaseResource terminologyEndpoint) {
        return Repositories.proxy(localRepository, useLocalData, Repositories.createRestRepository(localRepository.fhirContext(), dataEndpoint), Repositories.createRestRepository(localRepository.fhirContext(), contentEndpoint), Repositories.createRestRepository(localRepository.fhirContext(), terminologyEndpoint));
    }

    public static IRepository proxy(IRepository localRepository, Boolean useServerData, IRepository dataRepository, IRepository contentRepository, IRepository terminologyRepository) {
        Boolean useLocalData;
        Boolean bl = useLocalData = useServerData == null ? Boolean.TRUE : useServerData;
        if (dataRepository == null && contentRepository == null && terminologyRepository == null && Boolean.TRUE.equals(useLocalData)) {
            return localRepository;
        }
        return new ProxyRepository(localRepository, useLocalData, dataRepository, contentRepository, terminologyRepository);
    }

    public static ResourceMatcher getResourceMatcher(FhirContext context) {
        FhirVersionEnum fhirVersion = context.getVersion().getVersion();
        return switch (fhirVersion) {
            case FhirVersionEnum.DSTU3 -> new ResourceMatcherDSTU3();
            case FhirVersionEnum.R4 -> new ResourceMatcherR4();
            case FhirVersionEnum.R5 -> new ResourceMatcherR5();
            default -> throw new NotImplementedException("Resource matching is not implemented for FHIR version: %s".formatted(fhirVersion.getFhirVersionString()));
        };
    }
}

