/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.repository;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.repository.IRepository;
import java.util.Map;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.fhir.utility.adapter.IAdapterFactory;
import org.opencds.cqf.fhir.utility.monad.Either3;
import org.opencds.cqf.fhir.utility.monad.Eithers;
import org.opencds.cqf.fhir.utility.repository.IRepositoryOperationProvider;
import org.opencds.cqf.fhir.utility.repository.operations.IActivityDefinitionProcessor;
import org.opencds.cqf.fhir.utility.repository.operations.IActivityDefinitionProcessorFactory;
import org.opencds.cqf.fhir.utility.repository.operations.OperationParametersParser;

public class RepositoryOperationProvider
implements IRepositoryOperationProvider {
    private final FhirContext fhirContext;
    private final OperationParametersParser operationParametersParser;
    private IActivityDefinitionProcessorFactory activityDefinitionProcessorFactory;

    public RepositoryOperationProvider(FhirContext fhirContext) {
        this.fhirContext = fhirContext;
        this.operationParametersParser = new OperationParametersParser(IAdapterFactory.forFhirVersion(this.fhirContext.getVersion().getVersion()));
    }

    public void setActivityDefinitionProcessorFactory(IActivityDefinitionProcessorFactory activityDefinitionProcessorFactory) {
        this.activityDefinitionProcessorFactory = activityDefinitionProcessorFactory;
    }

    @Override
    public <C extends IPrimitiveType<String>, R extends IBaseResource> R invokeOperation(IRepository repository, IIdType id, String resourceType, String operationName, IBaseParameters parameters) {
        if (resourceType.equals("ActivityDefinition") && this.activityDefinitionProcessorFactory != null) {
            IActivityDefinitionProcessor processor = this.activityDefinitionProcessorFactory.create(repository);
            Map<String, Object> paramMap = this.operationParametersParser.getParameterParts(parameters);
            switch (operationName) {
                case "$apply": {
                    Either3<IPrimitiveType, IIdType, IBaseResource> activityDefinition = Eithers.for3((IPrimitiveType)paramMap.get("canonical"), id, (IBaseResource)paramMap.get("activityDefinition"));
                    String subject = (String)((IPrimitiveType)paramMap.get("subject")).getValue();
                    IPrimitiveType encounter = (IPrimitiveType)paramMap.get("encounter");
                    IPrimitiveType practitioner = (IPrimitiveType)paramMap.get("practitioner");
                    IPrimitiveType organization = (IPrimitiveType)paramMap.get("organization");
                    return (R)processor.apply(activityDefinition, subject, encounter == null ? null : (String)encounter.getValue(), practitioner == null ? null : (String)practitioner.getValue(), organization == null ? null : (String)organization.getValue(), (IBaseDatatype)paramMap.get("userType"), (IBaseDatatype)paramMap.get("userLanguage"), (IBaseDatatype)paramMap.get("userTaskContext"), (IBaseDatatype)paramMap.get("setting"), (IBaseDatatype)paramMap.get("settingContext"), (IBaseParameters)paramMap.get("parameters"), (Boolean)paramMap.get("useServerData"), (IBaseBundle)paramMap.get("data"), (IBaseResource)paramMap.get("dataEndpoint"), (IBaseResource)paramMap.get("contentEndpoint"), (IBaseResource)paramMap.get("terminologyEndpoint"));
                }
            }
            throw new IllegalArgumentException("(%s) operation not supported for type (%s)".formatted(operationName, resourceType));
        }
        return null;
    }
}

