/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.repository.ig;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.repository.IRepository;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.server.exceptions.ForbiddenOperationException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.exceptions.UnclassifiedServerFailureException;
import ca.uhn.fhir.util.BundleBuilder;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.fhir.utility.Ids;
import org.opencds.cqf.fhir.utility.matcher.ResourceMatcher;
import org.opencds.cqf.fhir.utility.repository.Repositories;
import org.opencds.cqf.fhir.utility.repository.ig.CqlContent;
import org.opencds.cqf.fhir.utility.repository.ig.EncodingBehavior;
import org.opencds.cqf.fhir.utility.repository.ig.IgConventions;
import org.opencds.cqf.fhir.utility.repository.ig.IgRepositoryCompartment;
import org.opencds.cqf.fhir.utility.repository.ig.ResourceCategory;
import org.opencds.cqf.fhir.utility.repository.operations.IRepositoryOperationProvider;

public class IgRepository
implements IRepository {
    private final FhirContext fhirContext;
    private final Path root;
    private final IgConventions conventions;
    private final EncodingBehavior encodingBehavior;
    private final ResourceMatcher resourceMatcher;
    private IRepositoryOperationProvider operationProvider;
    private final Cache<Path, IBaseResource> resourceCache = CacheBuilder.newBuilder().concurrencyLevel(10).maximumSize(500L).build();
    static final String SOURCE_PATH_TAG = "sourcePath";
    static final String EXTERNAL_DIRECTORY = "external";
    static final Map<ResourceCategory, String> CATEGORY_DIRECTORIES = new ImmutableMap.Builder().put((Object)ResourceCategory.CONTENT, (Object)"resources").put((Object)ResourceCategory.DATA, (Object)"tests").put((Object)ResourceCategory.TERMINOLOGY, (Object)"vocabulary").build();
    static final BiMap<EncodingEnum, String> FILE_EXTENSIONS = new ImmutableBiMap.Builder().put((Object)EncodingEnum.JSON, (Object)"json").put((Object)EncodingEnum.XML, (Object)"xml").put((Object)EncodingEnum.RDF, (Object)"rdf").build();
    public static final String FHIR_COMPARTMENT_HEADER = "X-FHIR-Compartment";

    private static IParser parserForEncoding(FhirContext fhirContext, EncodingEnum encodingEnum) {
        return switch (encodingEnum) {
            case EncodingEnum.JSON -> fhirContext.newJsonParser();
            case EncodingEnum.XML -> fhirContext.newXmlParser();
            case EncodingEnum.RDF -> fhirContext.newRDFParser();
            default -> throw new IllegalArgumentException("NDJSON is not supported");
        };
    }

    public IgRepository(FhirContext fhirContext, Path root) {
        this(fhirContext, root, IgConventions.autoDetect(root), EncodingBehavior.DEFAULT, null);
    }

    public IgRepository(FhirContext fhirContext, Path root, IgConventions conventions, EncodingBehavior encodingBehavior, IRepositoryOperationProvider operationProvider) {
        this.fhirContext = Objects.requireNonNull(fhirContext, "fhirContext cannot be null");
        this.root = Objects.requireNonNull(root, "root cannot be null");
        this.conventions = Objects.requireNonNull(conventions, "conventions is required");
        this.encodingBehavior = Objects.requireNonNull(encodingBehavior, "encodingBehavior is required");
        this.resourceMatcher = Repositories.getResourceMatcher(this.fhirContext);
        this.operationProvider = operationProvider;
    }

    public void setOperationProvider(IRepositoryOperationProvider operationProvider) {
        this.operationProvider = operationProvider;
    }

    public void clearCache() {
        this.resourceCache.invalidateAll();
    }

    private boolean isExternalPath(Path path) {
        return path.getParent() != null && path.getParent().toString().toLowerCase().endsWith(EXTERNAL_DIRECTORY);
    }

    protected <T extends IBaseResource, I extends IIdType> Path preferredPathForResource(Class<T> resourceType, I id, IgRepositoryCompartment igRepositoryCompartment) {
        Path directory = this.directoryForResource(resourceType, igRepositoryCompartment);
        String fileName = this.fileNameForResource(resourceType.getSimpleName(), id.getIdPart(), this.encodingBehavior.preferredEncoding());
        return directory.resolve(fileName);
    }

    protected <T extends IBaseResource, I extends IIdType> List<Path> potentialPathsForResource(Class<T> resourceType, I id, IgRepositoryCompartment igRepositoryCompartment) {
        ArrayList<Path> potentialDirectories = new ArrayList<Path>();
        Path directory = this.directoryForResource(resourceType, igRepositoryCompartment);
        potentialDirectories.add(directory);
        if (ResourceCategory.forType(resourceType.getSimpleName()) == ResourceCategory.TERMINOLOGY) {
            Path externalDirectory = directory.resolve(EXTERNAL_DIRECTORY);
            potentialDirectories.add(externalDirectory);
        }
        ArrayList<Path> potentialPaths = new ArrayList<Path>();
        for (Path dir : potentialDirectories) {
            for (EncodingEnum encoding : FILE_EXTENSIONS.keySet()) {
                potentialPaths.add(dir.resolve(this.fileNameForResource(resourceType.getSimpleName(), id.getIdPart(), encoding)));
            }
        }
        return potentialPaths;
    }

    protected String fileNameForResource(String resourceType, String resourceId, EncodingEnum encoding) {
        String name = resourceId + "." + (String)FILE_EXTENSIONS.get((Object)encoding);
        if (IgConventions.FilenameMode.ID_ONLY.equals((Object)this.conventions.filenameMode())) {
            return name;
        }
        return resourceType + "-" + name;
    }

    protected <T extends IBaseResource> Path directoryForCategory(Class<T> resourceType, IgRepositoryCompartment igRepositoryCompartment) {
        if (this.conventions.categoryLayout() == IgConventions.CategoryLayout.FLAT) {
            return this.root;
        }
        ResourceCategory category = ResourceCategory.forType(resourceType.getSimpleName());
        String directory = CATEGORY_DIRECTORIES.get((Object)category);
        Path path = this.root.resolve(directory);
        if (category == ResourceCategory.DATA && this.conventions.compartmentLayout() == IgConventions.CompartmentLayout.DIRECTORY_PER_COMPARTMENT) {
            path = path.resolve(this.pathForCompartment(igRepositoryCompartment));
        }
        return path;
    }

    protected <T extends IBaseResource> Path directoryForResource(Class<T> resourceType, IgRepositoryCompartment igRepositoryCompartment) {
        Path directory = this.directoryForCategory(resourceType, igRepositoryCompartment);
        if (this.conventions.typeLayout() == IgConventions.FhirTypeLayout.FLAT) {
            return directory;
        }
        return directory.resolve(resourceType.getSimpleName().toLowerCase());
    }

    @Nullable
    protected IBaseResource readResource(Path path) {
        File file = path.toFile();
        if (!file.exists()) {
            return null;
        }
        String extension = this.fileExtension(path);
        if (extension == null) {
            return null;
        }
        EncodingEnum encoding = (EncodingEnum)FILE_EXTENSIONS.inverse().get((Object)extension);
        try {
            String s = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
            IBaseResource resource = IgRepository.parserForEncoding(this.fhirContext, encoding).parseResource(s);
            resource.setUserData(SOURCE_PATH_TAG, (Object)path);
            CqlContent.loadCqlContent(resource, path.getParent());
            return resource;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (DataFormatException e) {
            throw new ResourceNotFoundException("Found empty or invalid content at path %s".formatted(path));
        }
        catch (IOException e) {
            throw new UnclassifiedServerFailureException(500, "Unable to read resource from path %s".formatted(path));
        }
    }

    protected IBaseResource cachedReadResource(Path path) {
        IBaseResource o = (IBaseResource)this.resourceCache.getIfPresent((Object)path);
        if (o != null) {
            return o;
        }
        IBaseResource resource = this.readResource(path);
        this.resourceCache.put((Object)path, (Object)resource);
        return resource;
    }

    protected EncodingEnum encodingForPath(Path path) {
        String extension = this.fileExtension(path);
        return (EncodingEnum)FILE_EXTENSIONS.inverse().get((Object)extension);
    }

    protected <T extends IBaseResource> void writeResource(T resource, Path path) {
        try {
            if (path.getParent() != null) {
                path.getParent().toFile().mkdirs();
            }
            try (FileOutputStream stream = new FileOutputStream(path.toFile());){
                String result = IgRepository.parserForEncoding(this.fhirContext, this.encodingForPath(path)).setPrettyPrint(true).encodeResourceToString(resource);
                stream.write(result.getBytes());
                resource.setUserData(SOURCE_PATH_TAG, (Object)path);
                this.resourceCache.put((Object)path, resource);
            }
        }
        catch (IOException | SecurityException e) {
            throw new UnclassifiedServerFailureException(500, "Unable to write resource to path %s".formatted(path));
        }
    }

    private String fileExtension(Path path) {
        String name = path.getFileName().toString();
        int lastPeriod = name.lastIndexOf(".");
        if (lastPeriod == -1) {
            return null;
        }
        return name.substring(lastPeriod + 1).toLowerCase();
    }

    private boolean acceptByFileExtension(Path path) {
        String extension = this.fileExtension(path);
        if (extension == null) {
            return false;
        }
        return FILE_EXTENSIONS.containsValue((Object)extension);
    }

    private boolean acceptByFileExtensionAndPrefix(Path path, String prefix) {
        boolean extensionAccepted = this.acceptByFileExtension(path);
        if (!extensionAccepted) {
            return false;
        }
        return path.getFileName().toString().toLowerCase().startsWith(prefix.toLowerCase() + "-");
    }

    protected <T extends IBaseResource> Map<IIdType, T> readDirectoryForResourceType(Class<T> resourceClass, IgRepositoryCompartment igRepositoryCompartment) {
        Path path = this.directoryForResource(resourceClass, igRepositoryCompartment);
        if (!path.toFile().exists()) {
            return Collections.emptyMap();
        }
        ConcurrentHashMap resources = new ConcurrentHashMap();
        Predicate<Path> resourceFileFilter = switch (this.conventions.filenameMode()) {
            case IgConventions.FilenameMode.ID_ONLY -> this::acceptByFileExtension;
            default -> p -> this.acceptByFileExtensionAndPrefix((Path)p, resourceClass.getSimpleName());
        };
        try (Stream<Path> paths = Files.walk(path, new FileVisitOption[0]);){
            ((Stream)paths.filter(resourceFileFilter).parallel()).map(this::cachedReadResource).filter(Objects::nonNull).forEach(r -> {
                if (!r.fhirType().equals(resourceClass.getSimpleName())) {
                    return;
                }
                Object validatedResource = this.validateResource(resourceClass, (IBaseResource)r, r.getIdElement());
                resources.put(r.getIdElement().toUnqualifiedVersionless(), validatedResource);
            });
        }
        catch (IOException e) {
            throw new UnclassifiedServerFailureException(500, "Unable to read resources from path: %s".formatted(path));
        }
        return resources;
    }

    public FhirContext fhirContext() {
        return this.fhirContext;
    }

    public <T extends IBaseResource, I extends IIdType> T read(Class<T> resourceType, I id, Map<String, String> headers) {
        Objects.requireNonNull(resourceType, "resourceType cannot be null");
        Objects.requireNonNull(id, "id cannot be null");
        IgRepositoryCompartment compartment = this.compartmentFrom(headers);
        List<Path> paths = this.potentialPathsForResource(resourceType, id, compartment);
        for (Path path : paths) {
            IBaseResource resource;
            if (!path.toFile().exists() || (resource = this.cachedReadResource(path)) == null) continue;
            return this.validateResource(resourceType, resource, id);
        }
        throw new ResourceNotFoundException(id);
    }

    public <T extends IBaseResource> MethodOutcome create(T resource, Map<String, String> headers) {
        Objects.requireNonNull(resource, "resource cannot be null");
        Objects.requireNonNull(resource.getIdElement().getIdPart(), "resource id cannot be null");
        IgRepositoryCompartment compartment = this.compartmentFrom(headers);
        Path path = this.preferredPathForResource(resource.getClass(), resource.getIdElement(), compartment);
        this.writeResource(resource, path);
        return new MethodOutcome(resource.getIdElement(), Boolean.valueOf(true));
    }

    private <T extends IBaseResource> T validateResource(Class<T> resourceType, IBaseResource resource, IIdType id) {
        Path path = (Path)resource.getUserData(SOURCE_PATH_TAG);
        if (!resourceType.getSimpleName().equals(resource.fhirType())) {
            throw new ResourceNotFoundException("Expected to find a resource with type: %s at path: %s. Found resource with type %s instead.".formatted(resourceType.getSimpleName(), path, resource.fhirType()));
        }
        if (!resource.getIdElement().hasIdPart()) {
            throw new ResourceNotFoundException("Expected to find a resource with id: %s at path: %s. Found resource without an id instead.".formatted(id.toUnqualifiedVersionless(), path));
        }
        if (!id.getIdPart().equals(resource.getIdElement().getIdPart())) {
            throw new ResourceNotFoundException("Expected to find a resource with id: %s at path: %s. Found resource with an id %s instead.".formatted(id.getIdPart(), path, resource.getIdElement().getIdPart()));
        }
        if (id.hasVersionIdPart() && !id.getVersionIdPart().equals(resource.getIdElement().getVersionIdPart())) {
            throw new ResourceNotFoundException("Expected to find a resource with version: %s at path: %s. Found resource with version %s instead.".formatted(id.getVersionIdPart(), path, resource.getIdElement().getVersionIdPart()));
        }
        return (T)((IBaseResource)resourceType.cast(resource));
    }

    public <T extends IBaseResource> MethodOutcome update(T resource, Map<String, String> headers) {
        Objects.requireNonNull(resource, "resource cannot be null");
        Objects.requireNonNull(resource.getIdElement().getIdPart(), "resource id cannot be null");
        IgRepositoryCompartment compartment = this.compartmentFrom(headers);
        Path preferred = this.preferredPathForResource(resource.getClass(), resource.getIdElement(), compartment);
        Path actual = (Path)resource.getUserData(SOURCE_PATH_TAG);
        if (actual == null) {
            actual = preferred;
        }
        if (this.isExternalPath(actual)) {
            throw new ForbiddenOperationException("Unable to create or update: %s. Resource is marked as external, and external resources are read-only.".formatted(resource.getIdElement().toUnqualifiedVersionless()));
        }
        if (!preferred.equals(actual) && this.encodingBehavior.preserveEncoding() == EncodingBehavior.PreserveEncoding.OVERWRITE_WITH_PREFERRED_ENCODING) {
            try {
                Files.deleteIfExists(actual);
            }
            catch (IOException e) {
                throw new UnclassifiedServerFailureException(500, "Couldn't change encoding for %s".formatted(actual));
            }
            actual = preferred;
        }
        this.writeResource(resource, actual);
        return new MethodOutcome(resource.getIdElement(), Boolean.valueOf(false));
    }

    public <T extends IBaseResource, I extends IIdType> MethodOutcome delete(Class<T> resourceType, I id, Map<String, String> headers) {
        Objects.requireNonNull(resourceType, "resourceType cannot be null");
        Objects.requireNonNull(id, "id cannot be null");
        IgRepositoryCompartment compartment = this.compartmentFrom(headers);
        List<Path> paths = this.potentialPathsForResource(resourceType, id, compartment);
        boolean deleted = false;
        for (Path path : paths) {
            try {
                deleted = Files.deleteIfExists(path);
                if (!deleted) continue;
                break;
            }
            catch (IOException e) {
                throw new UnclassifiedServerFailureException(500, "Couldn't delete %s".formatted(path));
            }
        }
        if (!deleted) {
            throw new ResourceNotFoundException(id);
        }
        return new MethodOutcome(id);
    }

    public <B extends IBaseBundle, T extends IBaseResource> B search(Class<B> bundleType, Class<T> resourceType, Multimap<String, List<IQueryParameterType>> searchParameters, Map<String, String> headers) {
        Collection<T> candidates;
        Map<IIdType, T> resourceIdMap;
        BundleBuilder builder;
        block7: {
            block6: {
                builder = new BundleBuilder(this.fhirContext);
                builder.setType("searchset");
                IgRepositoryCompartment compartment = this.compartmentFrom(headers);
                resourceIdMap = this.readDirectoryForResourceType(resourceType, compartment);
                if (searchParameters == null) break block6;
                if (!searchParameters.isEmpty()) break block7;
            }
            resourceIdMap.values().forEach(arg_0 -> ((BundleBuilder)builder).addCollectionEntry(arg_0));
            return (B)builder.getBundle();
        }
        if (searchParameters.containsKey((Object)"_id")) {
            candidates = this.getIdCandidates(searchParameters.get((Object)"_id"), resourceIdMap, resourceType);
            searchParameters.removeAll((Object)"_id");
        } else {
            candidates = resourceIdMap.values();
        }
        for (IBaseResource resource : candidates) {
            if (!this.allParametersMatch(searchParameters, resource)) continue;
            builder.addCollectionEntry(resource);
        }
        return (B)builder.getBundle();
    }

    private <T extends IBaseResource> List<T> getIdCandidates(Collection<List<IQueryParameterType>> idQueries, Map<IIdType, T> resourceIdMap, Class<T> resourceType) {
        ArrayList<IBaseResource> idResources = new ArrayList<IBaseResource>();
        for (List<IQueryParameterType> idQuery : idQueries) {
            for (IQueryParameterType query : idQuery) {
                if (!(query instanceof TokenParam)) continue;
                TokenParam idToken = (TokenParam)query;
                Object id = Ids.newId(this.fhirContext, resourceType.getSimpleName(), idToken.getValue());
                IBaseResource resource = (IBaseResource)resourceIdMap.get(id);
                if (resource == null) continue;
                idResources.add(resource);
            }
        }
        return idResources;
    }

    private boolean allParametersMatch(Multimap<String, List<IQueryParameterType>> searchParameters, IBaseResource resource) {
        for (Map.Entry nextEntry : searchParameters.entries()) {
            String paramName = (String)nextEntry.getKey();
            if (this.resourceMatcher.matches(paramName, (List)nextEntry.getValue(), resource)) continue;
            return false;
        }
        return true;
    }

    public <R extends IBaseResource, P extends IBaseParameters, T extends IBaseResource> R invoke(Class<T> resourceType, String name, P parameters, Class<R> returnType, Map<String, String> headers) {
        return this.invokeOperation(null, resourceType.getSimpleName(), name, parameters);
    }

    public <R extends IBaseResource, P extends IBaseParameters, I extends IIdType> R invoke(I id, String name, P parameters, Class<R> returnType, Map<String, String> headers) {
        return this.invokeOperation(id, id.getResourceType(), name, parameters);
    }

    protected <R extends IBaseResource> R invokeOperation(IIdType id, String resourceType, String operationName, IBaseParameters parameters) {
        if (this.operationProvider == null) {
            throw new IllegalArgumentException("No operation provider found. Unable to invoke operations.");
        }
        return this.operationProvider.invokeOperation(this, id, resourceType, operationName, parameters);
    }

    protected IgRepositoryCompartment compartmentFrom(Map<String, String> headers) {
        if (headers == null) {
            return new IgRepositoryCompartment();
        }
        String compartmentHeader = headers.get(FHIR_COMPARTMENT_HEADER);
        return compartmentHeader == null ? new IgRepositoryCompartment() : new IgRepositoryCompartment(compartmentHeader);
    }

    protected String pathForCompartment(IgRepositoryCompartment igRepositoryCompartment) {
        if (igRepositoryCompartment.isEmpty()) {
            return "";
        }
        return igRepositoryCompartment.getType() + "/" + igRepositoryCompartment.getId();
    }
}

