/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.repository.ig;

import java.util.Objects;
import java.util.StringJoiner;

public class IgRepositoryCompartment {
    private final String type;
    private final String id;

    private static String typeOfContext(String context) {
        return context.split("/")[0];
    }

    private static String idOfContext(String context) {
        return context.split("/")[1];
    }

    public IgRepositoryCompartment() {
        this.type = null;
        this.id = null;
    }

    public IgRepositoryCompartment(String context) {
        this(IgRepositoryCompartment.typeOfContext(context), IgRepositoryCompartment.idOfContext(context));
    }

    public IgRepositoryCompartment(String type, String id) {
        this.type = IgRepositoryCompartment.requireNonNullOrEmpty("type", type).toLowerCase();
        this.id = IgRepositoryCompartment.requireNonNullOrEmpty("id", id);
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public boolean isEmpty() {
        return this.type == null || this.id == null;
    }

    private static String requireNonNullOrEmpty(String name, String value) {
        Objects.requireNonNull(name, "name cannot be null");
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException(name + " cannot be null or empty");
        }
        return value;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IgRepositoryCompartment that = (IgRepositoryCompartment)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id);
    }

    public String toString() {
        return new StringJoiner(", ", IgRepositoryCompartment.class.getSimpleName() + "[", "]").add("type='" + this.type + "'").add("id='" + this.id + "'").toString();
    }
}

