/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.SearchParameter;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Resource;
import org.opencds.cqf.fhir.utility.Canonicals;

public class BundleHelper {
    private static final String UNSUPPORTED_VERSION_OF_FHIR = "Unsupported version of FHIR: %s";

    private BundleHelper() {
    }

    public static IBaseBackboneElement getEntryFirstRep(IBaseBundle bundle) {
        FhirVersionEnum fhirVersion = bundle.getStructureFhirVersionEnum();
        return switch (fhirVersion) {
            case FhirVersionEnum.DSTU3 -> ((org.hl7.fhir.dstu3.model.Bundle)bundle).getEntryFirstRep();
            case FhirVersionEnum.R4 -> ((org.hl7.fhir.r4.model.Bundle)bundle).getEntryFirstRep();
            case FhirVersionEnum.R5 -> ((Bundle)bundle).getEntryFirstRep();
            default -> throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
        };
    }

    public static IBaseResource getEntryResourceFirstRep(IBaseBundle bundle) {
        FhirVersionEnum fhirVersion = bundle.getStructureFhirVersionEnum();
        return switch (fhirVersion) {
            case FhirVersionEnum.DSTU3 -> {
                Bundle.BundleEntryComponent dstu3Entry = ((org.hl7.fhir.dstu3.model.Bundle)bundle).getEntryFirstRep();
                if (dstu3Entry != null && dstu3Entry.hasResource()) {
                    yield dstu3Entry.getResource();
                }
                yield null;
            }
            case FhirVersionEnum.R4 -> {
                Bundle.BundleEntryComponent r4Entry = ((org.hl7.fhir.r4.model.Bundle)bundle).getEntryFirstRep();
                if (r4Entry != null && r4Entry.hasResource()) {
                    yield r4Entry.getResource();
                }
                yield null;
            }
            case FhirVersionEnum.R5 -> {
                Bundle.BundleEntryComponent r5Entry = ((Bundle)bundle).getEntryFirstRep();
                if (r5Entry != null && r5Entry.hasResource()) {
                    yield r5Entry.getResource();
                }
                yield null;
            }
            default -> throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
        };
    }

    public static List<IBaseResource> getEntryResources(IBaseBundle bundle) {
        ArrayList<IBaseResource> resources = new ArrayList<IBaseResource>();
        FhirVersionEnum fhirVersion = bundle.getStructureFhirVersionEnum();
        switch (fhirVersion) {
            case DSTU3: {
                List dstu3Entry = ((org.hl7.fhir.dstu3.model.Bundle)bundle).getEntry();
                dstu3Entry.stream().filter(Bundle.BundleEntryComponent::hasResource).forEach(entry -> resources.add((IBaseResource)entry.getResource()));
                break;
            }
            case R4: {
                List r4Entry = ((org.hl7.fhir.r4.model.Bundle)bundle).getEntry();
                r4Entry.stream().filter(Bundle.BundleEntryComponent::hasResource).forEach(entry -> resources.add((IBaseResource)entry.getResource()));
                break;
            }
            case R5: {
                List r5Entry = ((Bundle)bundle).getEntry();
                r5Entry.stream().filter(Bundle.BundleEntryComponent::hasResource).forEach(entry -> resources.add((IBaseResource)entry.getResource()));
                break;
            }
            default: {
                throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
            }
        }
        return resources;
    }

    public static IBaseResource getEntryResource(FhirVersionEnum fhirVersion, IBaseBackboneElement entry) {
        return switch (fhirVersion) {
            case FhirVersionEnum.DSTU3 -> ((Bundle.BundleEntryComponent)entry).getResource();
            case FhirVersionEnum.R4 -> ((Bundle.BundleEntryComponent)entry).getResource();
            case FhirVersionEnum.R5 -> ((Bundle.BundleEntryComponent)entry).getResource();
            default -> throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
        };
    }

    public static boolean isEntryRequestPut(FhirVersionEnum fhirVersion, IBaseBackboneElement entry) {
        return switch (fhirVersion) {
            case FhirVersionEnum.DSTU3 -> Optional.ofNullable(((Bundle.BundleEntryComponent)entry).getRequest()).map(Bundle.BundleEntryRequestComponent::getMethod).filter(r -> r == Bundle.HTTPVerb.PUT).isPresent();
            case FhirVersionEnum.R4 -> Optional.ofNullable(((Bundle.BundleEntryComponent)entry).getRequest()).map(Bundle.BundleEntryRequestComponent::getMethod).filter(r -> r == Bundle.HTTPVerb.PUT).isPresent();
            case FhirVersionEnum.R5 -> Optional.ofNullable(((Bundle.BundleEntryComponent)entry).getRequest()).map(Bundle.BundleEntryRequestComponent::getMethod).filter(r -> r == Bundle.HTTPVerb.PUT).isPresent();
            default -> throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
        };
    }

    public static boolean isEntryRequestPost(FhirVersionEnum fhirVersion, IBaseBackboneElement entry) {
        return switch (fhirVersion) {
            case FhirVersionEnum.DSTU3 -> Optional.ofNullable(((Bundle.BundleEntryComponent)entry).getRequest()).map(Bundle.BundleEntryRequestComponent::getMethod).filter(r -> r == Bundle.HTTPVerb.POST).isPresent();
            case FhirVersionEnum.R4 -> Optional.ofNullable(((Bundle.BundleEntryComponent)entry).getRequest()).map(Bundle.BundleEntryRequestComponent::getMethod).filter(r -> r == Bundle.HTTPVerb.POST).isPresent();
            case FhirVersionEnum.R5 -> Optional.ofNullable(((Bundle.BundleEntryComponent)entry).getRequest()).map(Bundle.BundleEntryRequestComponent::getMethod).filter(r -> r == Bundle.HTTPVerb.POST).isPresent();
            default -> throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
        };
    }

    public static boolean isEntryRequestDelete(FhirVersionEnum fhirVersion, IBaseBackboneElement entry) {
        return switch (fhirVersion) {
            case FhirVersionEnum.DSTU3 -> Optional.ofNullable(((Bundle.BundleEntryComponent)entry).getRequest()).map(Bundle.BundleEntryRequestComponent::getMethod).filter(r -> r == Bundle.HTTPVerb.DELETE).isPresent();
            case FhirVersionEnum.R4 -> Optional.ofNullable(((Bundle.BundleEntryComponent)entry).getRequest()).map(Bundle.BundleEntryRequestComponent::getMethod).filter(r -> r == Bundle.HTTPVerb.DELETE).isPresent();
            case FhirVersionEnum.R5 -> Optional.ofNullable(((Bundle.BundleEntryComponent)entry).getRequest()).map(Bundle.BundleEntryRequestComponent::getMethod).filter(r -> r == Bundle.HTTPVerb.DELETE).isPresent();
            default -> throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
        };
    }

    public static <T extends IBaseBackboneElement> List<T> getEntry(IBaseBundle bundle) {
        FhirVersionEnum fhirVersion = bundle.getStructureFhirVersionEnum();
        return switch (fhirVersion) {
            case FhirVersionEnum.DSTU3 -> ((org.hl7.fhir.dstu3.model.Bundle)bundle).getEntry();
            case FhirVersionEnum.R4 -> ((org.hl7.fhir.r4.model.Bundle)bundle).getEntry();
            case FhirVersionEnum.R5 -> ((Bundle)bundle).getEntry();
            default -> throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
        };
    }

    public static Optional<IIdType> getEntryRequestId(FhirVersionEnum fhirVersion, IBaseBackboneElement entry) {
        return switch (fhirVersion) {
            case FhirVersionEnum.DSTU3 -> Optional.ofNullable(((Bundle.BundleEntryComponent)entry).getRequest().getUrl()).map(Canonicals::getIdPart).map(org.hl7.fhir.dstu3.model.IdType::new);
            case FhirVersionEnum.R4 -> Optional.ofNullable(((Bundle.BundleEntryComponent)entry).getRequest().getUrl()).map(Canonicals::getIdPart).map(org.hl7.fhir.r4.model.IdType::new);
            case FhirVersionEnum.R5 -> Optional.ofNullable(((Bundle.BundleEntryComponent)entry).getRequest().getUrl()).map(Canonicals::getIdPart).map(IdType::new);
            default -> throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
        };
    }

    public static List<IIdType> getBundleEntryResourceIds(FhirContext fhirContext, IBaseBundle bundle) {
        return BundleHelper.getBundleEntryResourceIds(fhirContext.getVersion().getVersion(), bundle);
    }

    public static List<IIdType> getBundleEntryResourceIds(FhirVersionEnum fhirVersion, IBaseBundle bundle) {
        List<IBaseBackboneElement> entry = BundleHelper.getEntry(bundle);
        if (entry.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IIdType> retVal = new ArrayList<IIdType>(entry.size());
        entry.forEach(e -> retVal.add(BundleHelper.getEntryResource(fhirVersion, e).getIdElement()));
        return retVal;
    }

    public static String getEntryRequestUrl(FhirVersionEnum fhirVersion, IBaseBackboneElement entry) {
        return switch (fhirVersion) {
            case FhirVersionEnum.DSTU3 -> ((Bundle.BundleEntryComponent)entry).getRequest().getUrl();
            case FhirVersionEnum.R4 -> ((Bundle.BundleEntryComponent)entry).getRequest().getUrl();
            case FhirVersionEnum.R5 -> ((Bundle.BundleEntryComponent)entry).getRequest().getUrl();
            default -> throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
        };
    }

    public static void setEntry(IBaseBundle bundle, List<? extends IBaseBackboneElement> entries) {
        FhirVersionEnum fhirVersion = bundle.getStructureFhirVersionEnum();
        switch (fhirVersion) {
            case DSTU3: {
                ((org.hl7.fhir.dstu3.model.Bundle)bundle).setEntry(entries);
                break;
            }
            case R4: {
                ((org.hl7.fhir.r4.model.Bundle)bundle).setEntry(entries);
                break;
            }
            case R5: {
                ((Bundle)bundle).setEntry(entries);
                break;
            }
            default: {
                throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
            }
        }
    }

    public static IBaseBundle addEntry(IBaseBundle bundle, IBaseBackboneElement entry) {
        FhirVersionEnum fhirVersion = bundle.getStructureFhirVersionEnum();
        switch (fhirVersion) {
            case DSTU3: {
                ((org.hl7.fhir.dstu3.model.Bundle)bundle).addEntry((Bundle.BundleEntryComponent)entry);
                break;
            }
            case R4: {
                ((org.hl7.fhir.r4.model.Bundle)bundle).addEntry((Bundle.BundleEntryComponent)entry);
                break;
            }
            case R5: {
                ((Bundle)bundle).addEntry((Bundle.BundleEntryComponent)entry);
                break;
            }
            default: {
                throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
            }
        }
        return bundle;
    }

    public static IBaseBundle newBundle(FhirVersionEnum fhirVersion) {
        return BundleHelper.newBundle(fhirVersion, null, null);
    }

    public static IBaseBundle newBundle(FhirVersionEnum fhirVersion, String type) {
        return BundleHelper.newBundle(fhirVersion, null, type);
    }

    public static IBaseBundle newBundle(FhirVersionEnum fhirVersion, String id, String type) {
        return switch (fhirVersion) {
            case FhirVersionEnum.DSTU3 -> BundleHelper.newDstu3Bundle(id, type);
            case FhirVersionEnum.R4 -> BundleHelper.newR4Bundle(id, type);
            case FhirVersionEnum.R5 -> BundleHelper.newR5Bundle(id, type);
            default -> throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
        };
    }

    @Nonnull
    private static Bundle newR5Bundle(String id, String type) {
        Bundle r5Bundle = new Bundle();
        if (id != null && !id.isEmpty()) {
            r5Bundle.setId(id);
        }
        r5Bundle.setType(type == null || type.isEmpty() ? Bundle.BundleType.COLLECTION : Bundle.BundleType.fromCode((String)type));
        return r5Bundle;
    }

    @Nonnull
    private static org.hl7.fhir.r4.model.Bundle newR4Bundle(String id, String type) {
        org.hl7.fhir.r4.model.Bundle r4Bundle = new org.hl7.fhir.r4.model.Bundle();
        if (id != null && !id.isEmpty()) {
            r4Bundle.setId(id);
        }
        r4Bundle.setType(type == null || type.isEmpty() ? Bundle.BundleType.COLLECTION : Bundle.BundleType.fromCode((String)type));
        return r4Bundle;
    }

    @Nonnull
    private static org.hl7.fhir.dstu3.model.Bundle newDstu3Bundle(String id, String type) {
        org.hl7.fhir.dstu3.model.Bundle dstu3Bundle = new org.hl7.fhir.dstu3.model.Bundle();
        if (id != null && !id.isEmpty()) {
            dstu3Bundle.setId(id);
        }
        dstu3Bundle.setType(type == null || type.isEmpty() ? Bundle.BundleType.COLLECTION : Bundle.BundleType.fromCode((String)type));
        return dstu3Bundle;
    }

    public static IBaseBundle setBundleType(IBaseBundle bundle, String bundleType) {
        FhirVersionEnum fhirVersion = bundle.getStructureFhirVersionEnum();
        return switch (fhirVersion) {
            case FhirVersionEnum.DSTU3 -> ((org.hl7.fhir.dstu3.model.Bundle)bundle).setType(Bundle.BundleType.fromCode((String)bundleType));
            case FhirVersionEnum.R4 -> ((org.hl7.fhir.r4.model.Bundle)bundle).setType(Bundle.BundleType.fromCode((String)bundleType));
            case FhirVersionEnum.R5 -> ((Bundle)bundle).setType(Bundle.BundleType.fromCode((String)bundleType));
            default -> throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
        };
    }

    public static IBaseBundle setBundleTotal(IBaseBundle bundle, int total) {
        FhirVersionEnum fhirVersion = bundle.getStructureFhirVersionEnum();
        return switch (fhirVersion) {
            case FhirVersionEnum.DSTU3 -> ((org.hl7.fhir.dstu3.model.Bundle)bundle).setTotal(total);
            case FhirVersionEnum.R4 -> ((org.hl7.fhir.r4.model.Bundle)bundle).setTotal(total);
            case FhirVersionEnum.R5 -> ((Bundle)bundle).setTotal(total);
            default -> throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
        };
    }

    public static IBaseBackboneElement newEntry(FhirVersionEnum fhirVersion) {
        return switch (fhirVersion) {
            case FhirVersionEnum.DSTU3 -> new Bundle.BundleEntryComponent();
            case FhirVersionEnum.R4 -> new Bundle.BundleEntryComponent();
            case FhirVersionEnum.R5 -> new Bundle.BundleEntryComponent();
            default -> throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
        };
    }

    public static IBaseBackboneElement newEntryWithResource(IBaseResource resource) {
        FhirVersionEnum fhirVersion = resource.getStructureFhirVersionEnum();
        return switch (fhirVersion) {
            case FhirVersionEnum.DSTU3 -> new Bundle.BundleEntryComponent().setResource((org.hl7.fhir.dstu3.model.Resource)resource);
            case FhirVersionEnum.R4 -> new Bundle.BundleEntryComponent().setResource((org.hl7.fhir.r4.model.Resource)resource);
            case FhirVersionEnum.R5 -> new Bundle.BundleEntryComponent().setResource((Resource)resource);
            default -> throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
        };
    }

    public static IBaseBackboneElement newEntryWithResponse(FhirVersionEnum fhirVersion, IBaseBackboneElement response) {
        return switch (fhirVersion) {
            case FhirVersionEnum.DSTU3 -> new Bundle.BundleEntryComponent().setResponse((Bundle.BundleEntryResponseComponent)response);
            case FhirVersionEnum.R4 -> new Bundle.BundleEntryComponent().setResponse((Bundle.BundleEntryResponseComponent)response);
            case FhirVersionEnum.R5 -> new Bundle.BundleEntryComponent().setResponse((Bundle.BundleEntryResponseComponent)response);
            default -> throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
        };
    }

    public static IBaseBackboneElement newResponseWithLocation(FhirVersionEnum fhirVersion, String location) {
        return switch (fhirVersion) {
            case FhirVersionEnum.DSTU3 -> new Bundle.BundleEntryResponseComponent().setLocation(location);
            case FhirVersionEnum.R4 -> new Bundle.BundleEntryResponseComponent().setLocation(location);
            case FhirVersionEnum.R5 -> new Bundle.BundleEntryResponseComponent().setLocation(location);
            default -> throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
        };
    }

    public static IBaseBackboneElement newRequest(FhirVersionEnum fhirVersion, String method, String url) {
        return switch (fhirVersion) {
            case FhirVersionEnum.DSTU3 -> new Bundle.BundleEntryRequestComponent().setMethod(Bundle.HTTPVerb.fromCode((String)method)).setUrl(url);
            case FhirVersionEnum.R4 -> new Bundle.BundleEntryRequestComponent().setMethod(Bundle.HTTPVerb.fromCode((String)method)).setUrl(url);
            case FhirVersionEnum.R5 -> new Bundle.BundleEntryRequestComponent().setMethod(Bundle.HTTPVerb.fromCode((String)method)).setUrl(url);
            default -> throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
        };
    }

    public static IBaseBackboneElement newRequest(FhirVersionEnum fhirVersion, String method) {
        return switch (fhirVersion) {
            case FhirVersionEnum.DSTU3 -> new Bundle.BundleEntryRequestComponent().setMethod(Bundle.HTTPVerb.fromCode((String)method));
            case FhirVersionEnum.R4 -> new Bundle.BundleEntryRequestComponent().setMethod(Bundle.HTTPVerb.fromCode((String)method));
            case FhirVersionEnum.R5 -> new Bundle.BundleEntryRequestComponent().setMethod(Bundle.HTTPVerb.fromCode((String)method));
            default -> throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
        };
    }

    public static IBaseBackboneElement setRequestUrl(FhirVersionEnum fhirVersion, IBaseBackboneElement request, String url) {
        return switch (fhirVersion) {
            case FhirVersionEnum.DSTU3 -> ((Bundle.BundleEntryRequestComponent)request).setUrl(url);
            case FhirVersionEnum.R4 -> ((Bundle.BundleEntryRequestComponent)request).setUrl(url);
            case FhirVersionEnum.R5 -> ((Bundle.BundleEntryRequestComponent)request).setUrl(url);
            default -> throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
        };
    }

    public static IBaseBackboneElement setRequestIfNoneExist(FhirVersionEnum fhirVersion, IBaseBackboneElement request, String ifNoneExist) {
        return switch (fhirVersion) {
            case FhirVersionEnum.DSTU3 -> ((Bundle.BundleEntryRequestComponent)request).setIfNoneExist(ifNoneExist);
            case FhirVersionEnum.R4 -> ((Bundle.BundleEntryRequestComponent)request).setIfNoneExist(ifNoneExist);
            case FhirVersionEnum.R5 -> ((Bundle.BundleEntryRequestComponent)request).setIfNoneExist(ifNoneExist);
            default -> throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
        };
    }

    public static IBaseBackboneElement setEntryFullUrl(FhirVersionEnum fhirVersion, IBaseBackboneElement entry, String fullUrl) {
        return switch (fhirVersion) {
            case FhirVersionEnum.DSTU3 -> ((Bundle.BundleEntryComponent)entry).setFullUrl(fullUrl);
            case FhirVersionEnum.R4 -> ((Bundle.BundleEntryComponent)entry).setFullUrl(fullUrl);
            case FhirVersionEnum.R5 -> ((Bundle.BundleEntryComponent)entry).setFullUrl(fullUrl);
            default -> throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
        };
    }

    public static IBaseBackboneElement setEntryRequest(FhirVersionEnum fhirVersion, IBaseBackboneElement entry, IBaseBackboneElement request) {
        String requestTypeError = "Request should be of type: %s";
        return switch (fhirVersion) {
            case FhirVersionEnum.DSTU3 -> {
                if (request != null && !(request instanceof Bundle.BundleEntryRequestComponent)) {
                    throw new IllegalArgumentException(requestTypeError.formatted("org.hl7.fhir.dstu3.model.Bundle.BundleEntryRequestComponent"));
                }
                yield ((Bundle.BundleEntryComponent)entry).setRequest((Bundle.BundleEntryRequestComponent)request);
            }
            case FhirVersionEnum.R4 -> {
                if (request != null && !(request instanceof Bundle.BundleEntryRequestComponent)) {
                    throw new IllegalArgumentException(requestTypeError.formatted("org.hl7.fhir.r4.model.Bundle.BundleEntryRequestComponent"));
                }
                yield ((Bundle.BundleEntryComponent)entry).setRequest((Bundle.BundleEntryRequestComponent)request);
            }
            case FhirVersionEnum.R5 -> {
                if (request != null && !(request instanceof Bundle.BundleEntryRequestComponent)) {
                    throw new IllegalArgumentException(requestTypeError.formatted("org.hl7.fhir.r5.model.Bundle.BundleEntryRequestComponent"));
                }
                yield ((Bundle.BundleEntryComponent)entry).setRequest((Bundle.BundleEntryRequestComponent)request);
            }
            default -> throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
        };
    }

    public static RuntimeSearchParam resourceToRuntimeSearchParam(IBaseResource resource) {
        FhirVersionEnum fhirVersion = resource.getStructureFhirVersionEnum();
        return switch (fhirVersion) {
            case FhirVersionEnum.DSTU3 -> {
                SearchParameter res = (SearchParameter)resource;
                yield new RuntimeSearchParam((IIdType)res.getIdElement(), res.getUrl(), res.getCode(), res.getDescription(), res.getExpression(), RestSearchParameterTypeEnum.REFERENCE, null, res.getTarget().stream().map(org.hl7.fhir.dstu3.model.StringType::toString).collect(Collectors.toSet()), RuntimeSearchParam.RuntimeSearchParamStatusEnum.ACTIVE, res.getBase().stream().map(org.hl7.fhir.dstu3.model.StringType::toString).toList());
            }
            case FhirVersionEnum.R4 -> {
                org.hl7.fhir.r4.model.SearchParameter resR4 = (org.hl7.fhir.r4.model.SearchParameter)resource;
                yield new RuntimeSearchParam((IIdType)resR4.getIdElement(), resR4.getUrl(), resR4.getCode(), resR4.getDescription(), resR4.getExpression(), RestSearchParameterTypeEnum.REFERENCE, null, resR4.getTarget().stream().map(StringType::toString).collect(Collectors.toSet()), RuntimeSearchParam.RuntimeSearchParamStatusEnum.ACTIVE, resR4.getBase().stream().map(StringType::toString).toList());
            }
            case FhirVersionEnum.R5 -> {
                org.hl7.fhir.r5.model.SearchParameter resR5 = (org.hl7.fhir.r5.model.SearchParameter)resource;
                yield new RuntimeSearchParam((IIdType)resR5.getIdElement(), resR5.getUrl(), resR5.getCode(), resR5.getDescription(), resR5.getExpression(), RestSearchParameterTypeEnum.REFERENCE, null, resR5.getTarget().stream().map(PrimitiveType::toString).collect(Collectors.toSet()), RuntimeSearchParam.RuntimeSearchParamStatusEnum.ACTIVE, resR5.getBase().stream().map(PrimitiveType::toString).toList());
            }
            default -> throw new IllegalArgumentException(UNSUPPORTED_VERSION_OF_FHIR.formatted(fhirVersion.getFhirVersionString()));
        };
    }
}

