/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility;

import ca.uhn.fhir.context.FhirVersionEnum;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r5.model.Endpoint;
import org.opencds.cqf.fhir.utility.adapter.IAdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.IParametersParameterComponentAdapter;

public class EndpointHelper {
    private EndpointHelper() {
    }

    public static IBaseResource getEndpoint(IParametersParameterComponentAdapter param) {
        return param.hasResource() ? param.getResource() : EndpointHelper.newEndpointResource(param.fhirContext().getVersion().getVersion(), param.getPrimitiveValue());
    }

    public static IBaseResource getEndpoint(FhirVersionEnum fhirVersion, IBaseBackboneElement param) {
        if (param == null) {
            return null;
        }
        IParametersParameterComponentAdapter adapter = IAdapterFactory.forFhirVersion(fhirVersion).createParametersParameter((IBase)param);
        return EndpointHelper.getEndpoint(adapter);
    }

    private static IBaseResource newEndpointResource(FhirVersionEnum fhirVersion, String address) {
        return switch (fhirVersion) {
            case FhirVersionEnum.DSTU3 -> new org.hl7.fhir.dstu3.model.Endpoint().setAddress(address);
            case FhirVersionEnum.R4 -> new org.hl7.fhir.r4.model.Endpoint().setAddress(address);
            case FhirVersionEnum.R5 -> new Endpoint().setAddress(address);
            default -> null;
        };
    }
}

