/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.opencds.cqf.fhir.utility.Reflections;

public class Libraries {
    private static final Map<FhirVersionEnum, LibraryFunctions> cachedFunctions = new ConcurrentHashMap<FhirVersionEnum, LibraryFunctions>();
    private static final String LIBRARY_RESOURCE_TYPE = "Library";

    private Libraries() {
    }

    static Optional<byte[]> getContent(IBaseResource library, LibraryFunctions libraryFunctions, String contentType) {
        for (IBase attachment : libraryFunctions.getAttachments().apply((IBase)library)) {
            byte[] content;
            String libraryContentType = libraryFunctions.getContentType().apply(attachment);
            if (libraryContentType == null || !libraryContentType.equals(contentType) || (content = libraryFunctions.getContent().apply(attachment)) == null) continue;
            return Optional.of(content);
        }
        return Optional.empty();
    }

    public static Optional<byte[]> getContent(IBaseResource library, String contentType) {
        Preconditions.checkNotNull((Object)library);
        Preconditions.checkArgument((boolean)library.fhirType().equals(LIBRARY_RESOURCE_TYPE));
        Preconditions.checkNotNull((Object)contentType);
        LibraryFunctions libraryFunctions = Libraries.getFunctions(library);
        return Libraries.getContent(library, libraryFunctions, contentType);
    }

    static LibraryFunctions getFunctions(IBaseResource library) {
        FhirVersionEnum fhirVersion = library.getStructureFhirVersionEnum();
        return cachedFunctions.computeIfAbsent(fhirVersion, Libraries::getFunctions);
    }

    static LibraryFunctions getFunctions(FhirVersionEnum fhirVersionEnum) {
        FhirContext fhirContext = FhirContext.forCached((FhirVersionEnum)fhirVersionEnum);
        Class libraryClass = fhirContext.getResourceDefinition(LIBRARY_RESOURCE_TYPE).getImplementingClass();
        Function<IBase, List<IBase>> attachments = Reflections.getFunction(libraryClass, "content");
        Function<IBase, String> contentType = Reflections.getPrimitiveFunction(fhirContext.getElementDefinition("Attachment").getImplementingClass(), "contentType");
        Function<IBase, byte[]> content = Reflections.getPrimitiveFunction(fhirContext.getElementDefinition("Attachment").getImplementingClass(), "data");
        Function<IBase, String> version = Reflections.getVersionFunction(libraryClass);
        Function<IBase, String> name = Reflections.getNameFunction(libraryClass);
        return new LibraryFunctions(attachments, contentType, content, version, name);
    }

    public static String getVersion(IBaseResource library) {
        Preconditions.checkNotNull((Object)library);
        Preconditions.checkArgument((boolean)library.fhirType().equals(LIBRARY_RESOURCE_TYPE));
        LibraryFunctions libraryFunctions = Libraries.getFunctions(library);
        return libraryFunctions.getVersion().apply((IBase)library);
    }

    public static String getName(IBaseResource library) {
        Preconditions.checkNotNull((Object)library);
        Preconditions.checkArgument((boolean)library.fhirType().equals(LIBRARY_RESOURCE_TYPE));
        LibraryFunctions libraryFunctions = Libraries.getFunctions(library);
        return libraryFunctions.getName().apply((IBase)library);
    }

    public static final class LibraryFunctions {
        private final Function<IBase, List<IBase>> getAttachments;
        private final Function<IBase, String> getContentType;
        private final Function<IBase, byte[]> getContent;
        private final Function<IBase, String> getVersion;
        private final Function<IBase, String> getName;

        LibraryFunctions(Function<IBase, List<IBase>> getAttachments, Function<IBase, String> getContentType, Function<IBase, byte[]> getContent, Function<IBase, String> getVersion, Function<IBase, String> getName) {
            this.getAttachments = getAttachments;
            this.getContentType = getContentType;
            this.getContent = getContent;
            this.getVersion = getVersion;
            this.getName = getName;
        }

        public Function<IBase, List<IBase>> getAttachments() {
            return this.getAttachments;
        }

        public Function<IBase, String> getContentType() {
            return this.getContentType;
        }

        public Function<IBase, byte[]> getContent() {
            return this.getContent;
        }

        public Function<IBase, String> getVersion() {
            return this.getVersion;
        }

        public Function<IBase, String> getName() {
            return this.getName;
        }
    }
}

