/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility;

import ca.uhn.fhir.context.FhirVersionEnum;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.Resources;
import org.opencds.cqf.fhir.utility.VersionUtilities;
import org.opencds.cqf.fhir.utility.adapter.IAdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.IKnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.adapter.IParametersAdapter;

public class PackageHelper {
    public static IBaseParameters packageParameters(FhirVersionEnum fhirVersion, IBaseResource terminologyEndpoint, boolean isPut) {
        IParametersAdapter params = IAdapterFactory.forFhirVersion(fhirVersion).createParameters((IBaseParameters)Resources.newBaseForVersion("Parameters", fhirVersion));
        if (terminologyEndpoint != null) {
            params.addParameter("terminologyEndpoint", terminologyEndpoint);
        }
        params.addParameter("isPut", (IBase)VersionUtilities.booleanTypeForVersion(fhirVersion, isPut));
        return (IBaseParameters)params.get();
    }

    public static IBaseBackboneElement createEntry(IBaseResource resource, boolean isPut) {
        IKnowledgeArtifactAdapter adapter;
        String method;
        FhirVersionEnum fhirVersion = resource.getStructureFhirVersionEnum();
        IBaseBackboneElement entry = BundleHelper.newEntryWithResource(resource);
        Object requestUrl = resource.fhirType();
        if (isPut) {
            method = "PUT";
            if (resource.getIdElement() != null && !StringUtils.isBlank((CharSequence)resource.getIdElement().getIdPart())) {
                requestUrl = (String)requestUrl + "/" + resource.getIdElement().getIdPart();
            }
        } else {
            method = "POST";
        }
        IBaseBackboneElement request = BundleHelper.newRequest(fhirVersion, method, (String)requestUrl);
        BundleHelper.setEntryRequest(fhirVersion, entry, request);
        if (IKnowledgeArtifactAdapter.isSupportedMetadataResource(resource) && (adapter = IAdapterFactory.forFhirVersion(fhirVersion).createKnowledgeArtifactAdapter((IDomainResource)resource)).hasUrl()) {
            String url = adapter.getUrl();
            if (adapter.hasVersion()) {
                BundleHelper.setEntryFullUrl(fhirVersion, entry, url + "|" + adapter.getVersion());
                if (!isPut) {
                    BundleHelper.setRequestIfNoneExist(fhirVersion, request, "url=%s&version=%s".formatted(url, adapter.getVersion()));
                }
            } else {
                BundleHelper.setEntryFullUrl(fhirVersion, entry, url);
                if (!isPut) {
                    BundleHelper.setRequestIfNoneExist(fhirVersion, request, "url=%s".formatted(url));
                }
            }
        }
        return entry;
    }

    public static IBaseBackboneElement deleteEntry(IBaseResource resource) {
        FhirVersionEnum fhirVersion = resource.getStructureFhirVersionEnum();
        IBaseBackboneElement entry = BundleHelper.newEntryWithResource(resource);
        String requestUrl = resource.fhirType() + "/" + resource.getIdElement().getIdPart();
        IBaseBackboneElement request = BundleHelper.newRequest(fhirVersion, "DELETE", requestUrl);
        BundleHelper.setEntryRequest(fhirVersion, entry, request);
        return entry;
    }
}

