/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Comparator;
import java.util.regex.Pattern;

public class VersionComparator
implements Comparator<String> {
    private static final Pattern DATE_PATTERN = Pattern.compile("^\\d{4}([-/]?\\d{2}){0,2}$");

    @Override
    public int compare(String v1, String v2) {
        boolean isV1SemVer = this.isStrictSemVer(v1);
        boolean isV2SemVer = this.isStrictSemVer(v2);
        if (isV1SemVer && isV2SemVer) {
            return this.compareSemVer(v1, v2);
        }
        boolean isV1Date = this.isDate(v1);
        boolean isV2Date = this.isDate(v2);
        if (isV1Date && isV2Date) {
            return this.compareDate(v1, v2);
        }
        return v1.compareTo(v2);
    }

    public boolean isStrictSemVer(String version) {
        if (version == null || version.isEmpty()) {
            return false;
        }
        String[] buildSplit = version.split("\\+", 2);
        String mainAndPre = buildSplit[0];
        String build = buildSplit.length > 1 ? buildSplit[1] : null;
        String[] preSplit = mainAndPre.split("-", 2);
        String core = preSplit[0];
        String pre = preSplit.length > 1 ? preSplit[1] : null;
        return !(!this.isValidCore(core) || pre != null && !this.isValidPreRelease(pre) || build != null && !this.isValidBuild(build));
    }

    private boolean isValidCore(String core) {
        String[] p = core.split("\\.", -1);
        if (p.length != 3) {
            return false;
        }
        return this.isValidNumericCorePart(p[0]) && this.isValidNumericCorePart(p[1]) && this.isValidNumericCorePart(p[2]);
    }

    private boolean isValidNumericCorePart(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        if (s.equals("0")) {
            return true;
        }
        if (s.charAt(0) == '0') {
            return false;
        }
        return this.allDigits(s);
    }

    private boolean isValidPreRelease(String pre) {
        String[] ids = pre.split("\\.", -1);
        if (ids.length == 0) {
            return false;
        }
        for (String id : ids) {
            if (this.isValidPreId(id)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidPreId(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        if (!this.allAlphaNumHyphen(s)) {
            return false;
        }
        if (this.allDigits(s)) {
            return s.equals("0") || s.charAt(0) != '0';
        }
        return this.containsLetterOrHyphen(s);
    }

    private boolean isValidBuild(String build) {
        String[] ids = build.split("\\.", -1);
        if (ids.length == 0) {
            return false;
        }
        for (String id : ids) {
            if (!id.isEmpty() && this.allAlphaNumHyphen(id)) continue;
            return false;
        }
        return true;
    }

    private boolean allDigits(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    private boolean containsLetterOrHyphen(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') && c != '-') continue;
            return true;
        }
        return false;
    }

    private boolean allAlphaNumHyphen(String s) {
        for (int i = 0; i < s.length(); ++i) {
            boolean ok;
            char c = s.charAt(i);
            boolean bl = ok = c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '-';
            if (ok) continue;
            return false;
        }
        return true;
    }

    private boolean isDate(String version) {
        return DATE_PATTERN.matcher(version).matches();
    }

    private int compareSemVer(String v1, String v2) {
        String[] buildSplit1 = v1.split("\\+", 2);
        String[] buildSplit2 = v2.split("\\+", 2);
        String mainAndPre1 = buildSplit1[0];
        String mainAndPre2 = buildSplit2[0];
        String[] preSplit1 = mainAndPre1.split("-", 2);
        String[] preSplit2 = mainAndPre2.split("-", 2);
        String core1 = preSplit1[0];
        String core2 = preSplit2[0];
        String pre1 = preSplit1.length > 1 ? preSplit1[1] : null;
        String pre2 = preSplit2.length > 1 ? preSplit2[1] : null;
        String[] parts1 = core1.split("\\.");
        String[] parts2 = core2.split("\\.");
        for (int i = 0; i < 3; ++i) {
            int n2;
            int n1 = Integer.parseInt(parts1[i]);
            if (n1 == (n2 = Integer.parseInt(parts2[i]))) continue;
            return Integer.compare(n1, n2);
        }
        if (pre1 == null && pre2 == null) {
            return 0;
        }
        if (pre1 == null) {
            return 1;
        }
        if (pre2 == null) {
            return -1;
        }
        return this.comparePreRelease(pre1, pre2);
    }

    private int comparePreRelease(String p1, String p2) {
        String[] parts1 = p1.split("\\.");
        String[] parts2 = p2.split("\\.");
        int common = Math.min(parts1.length, parts2.length);
        for (int i = 0; i < common; ++i) {
            String s1 = parts1[i];
            String s2 = parts2[i];
            boolean isNum1 = this.allDigits(s1);
            boolean isNum2 = this.allDigits(s2);
            if (isNum1 && isNum2) {
                long n2;
                long n1 = Long.parseLong(s1);
                if (n1 == (n2 = Long.parseLong(s2))) continue;
                return Long.compare(n1, n2);
            }
            if (isNum1 != isNum2) {
                return isNum1 ? -1 : 1;
            }
            int cmp = s1.compareTo(s2);
            if (cmp == 0) continue;
            return cmp;
        }
        return Integer.compare(parts1.length, parts2.length);
    }

    private int compareDate(String d1, String d2) {
        LocalDate date1 = this.parseDate(d1);
        LocalDate date2 = this.parseDate(d2);
        if (date1 == null || date2 == null) {
            return d1.compareTo(d2);
        }
        return date1.compareTo(date2);
    }

    private LocalDate parseDate(String input) {
        String[] formats;
        for (String fmt : formats = new String[]{"yyyyMMdd", "yyyy-MM-dd", "yyyy/MM/dd", "yyyyMM", "yyyy"}) {
            try {
                return LocalDate.parse(input, DateTimeFormatter.ofPattern(fmt));
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return null;
    }

    public int compareDatesDirect(String d1, String d2) {
        return this.compareDate(d1, d2);
    }
}

