/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.utility.adapter.IAdapter;
import org.opencds.cqf.fhir.utility.adapter.IAdapterFactory;
import org.opencds.cqf.fhir.utility.model.FhirModelResolverCache;

public abstract class BaseAdapter
implements IAdapter<IBase> {
    protected final FhirContext fhirContext;
    protected final IBase element;
    protected final ModelResolver modelResolver;
    protected final IAdapterFactory adapterFactory;

    protected BaseAdapter(FhirVersionEnum fhirVersion, IBase element) {
        if (element == null) {
            throw new IllegalArgumentException("element can not be null");
        }
        this.element = element;
        this.fhirContext = FhirContext.forCached((FhirVersionEnum)fhirVersion);
        this.adapterFactory = IAdapterFactory.forFhirContext(this.fhirContext);
        this.modelResolver = FhirModelResolverCache.resolverForVersion(this.fhirContext.getVersion().getVersion());
    }

    @Override
    public FhirContext fhirContext() {
        return this.fhirContext;
    }

    @Override
    public ModelResolver getModelResolver() {
        return this.modelResolver;
    }

    @Override
    public IAdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    @Override
    public <E extends IBaseExtension<?, ?>> E addExtension() {
        Object t = this.get();
        if (t instanceof IBaseHasExtensions) {
            IBaseHasExtensions baseHasExtensions = (IBaseHasExtensions)t;
            return (E)baseHasExtensions.addExtension();
        }
        return null;
    }
}

