/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter;

import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import com.google.common.collect.Sets;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.utility.adapter.IAdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.IResourceAdapter;
import org.opencds.cqf.fhir.utility.model.FhirModelResolverCache;

public abstract class BaseResourceAdapter
implements IResourceAdapter {
    protected final FhirContext fhirContext;
    protected final BaseRuntimeElementDefinition<?> elementDefinition;
    protected final IBaseResource resource;
    protected final ModelResolver modelResolver;
    protected final IAdapterFactory adapterFactory;
    protected static final Set<String> LIBRARY_TYPES = Sets.newHashSet((Object[])new String[]{"logic-library", "model-definition", "asset-collection", "module-definition"});
    protected static final Set<String> REFERENCE_EXTENSIONS = Sets.newHashSet((Object[])new String[]{"http://hl7.org/fhir/StructureDefinition/questionnaire-unitValueSet", "http://hl7.org/fhir/StructureDefinition/questionnaire-referenceProfile", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-lookupQuestionnaire", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-subQuestionnaire", "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-inputParameters", "http://hl7.org/fhir/StructureDefinition/cqf-expansionParameters", "http://hl7.org/fhir/StructureDefinition/cqf-cqlOptions"});
    protected static final Set<String> EXPRESSION_EXTENSIONS = Sets.newHashSet((Object[])new String[]{"http://hl7.org/fhir/StructureDefinition/variable", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-candidateExpression", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression", "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression", "http://hl7.org/fhir/StructureDefinition/cqf-expression"});
    protected static final Set<String> CANONICAL_EXTENSIONS = Sets.newHashSet((Object[])new String[]{"http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-effectiveDataRequirements", "http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-effectiveDataRequirements"});

    protected BaseResourceAdapter(IBaseResource resource) {
        if (resource == null) {
            throw new IllegalArgumentException("resource can not be null");
        }
        this.resource = resource;
        this.fhirContext = FhirContext.forCached((FhirVersionEnum)resource.getStructureFhirVersionEnum());
        this.adapterFactory = IAdapterFactory.forFhirContext(this.fhirContext);
        this.elementDefinition = this.fhirContext.getElementDefinition(this.resource.getClass());
        this.modelResolver = FhirModelResolverCache.resolverForVersion(this.fhirContext.getVersion().getVersion());
    }

    @Override
    public FhirContext fhirContext() {
        return this.fhirContext;
    }

    @Override
    public ModelResolver getModelResolver() {
        return this.modelResolver;
    }

    @Override
    public IBaseResource get() {
        return this.resource;
    }

    @Override
    public IAdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    @Override
    public <E extends IBaseExtension<?, ?>> E addExtension() {
        IBaseResource iBaseResource = this.get();
        if (iBaseResource instanceof IBaseHasExtensions) {
            IBaseHasExtensions baseHasExtensions = (IBaseHasExtensions)iBaseResource;
            return (E)baseHasExtensions.addExtension();
        }
        return null;
    }
}

