/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.opencds.cqf.fhir.utility.adapter.IActivityDefinitionAdapter;
import org.opencds.cqf.fhir.utility.adapter.IAdapter;
import org.opencds.cqf.fhir.utility.adapter.IAttachmentAdapter;
import org.opencds.cqf.fhir.utility.adapter.ICodeableConceptAdapter;
import org.opencds.cqf.fhir.utility.adapter.ICodingAdapter;
import org.opencds.cqf.fhir.utility.adapter.IDataRequirementAdapter;
import org.opencds.cqf.fhir.utility.adapter.IElementDefinitionAdapter;
import org.opencds.cqf.fhir.utility.adapter.IEndpointAdapter;
import org.opencds.cqf.fhir.utility.adapter.IGraphDefinitionAdapter;
import org.opencds.cqf.fhir.utility.adapter.IKnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.adapter.ILibraryAdapter;
import org.opencds.cqf.fhir.utility.adapter.IParametersAdapter;
import org.opencds.cqf.fhir.utility.adapter.IParametersParameterComponentAdapter;
import org.opencds.cqf.fhir.utility.adapter.IPlanDefinitionAdapter;
import org.opencds.cqf.fhir.utility.adapter.IQuestionnaireAdapter;
import org.opencds.cqf.fhir.utility.adapter.IQuestionnaireItemComponentAdapter;
import org.opencds.cqf.fhir.utility.adapter.IQuestionnaireResponseAdapter;
import org.opencds.cqf.fhir.utility.adapter.IQuestionnaireResponseItemAnswerComponentAdapter;
import org.opencds.cqf.fhir.utility.adapter.IQuestionnaireResponseItemComponentAdapter;
import org.opencds.cqf.fhir.utility.adapter.IRequestActionAdapter;
import org.opencds.cqf.fhir.utility.adapter.IResourceAdapter;
import org.opencds.cqf.fhir.utility.adapter.IStructureDefinitionAdapter;
import org.opencds.cqf.fhir.utility.adapter.ITupleAdapter;
import org.opencds.cqf.fhir.utility.adapter.IValueSetAdapter;
import org.opencds.cqf.fhir.utility.adapter.r5.AdapterFactory;

public interface IAdapterFactory {
    public static IAdapterFactory forFhirContext(FhirContext fhirContext) {
        return IAdapterFactory.forFhirVersion(fhirContext.getVersion().getVersion());
    }

    public static IAdapterFactory forFhirVersion(FhirVersionEnum fhirVersion) {
        return switch (fhirVersion) {
            case FhirVersionEnum.DSTU3 -> new org.opencds.cqf.fhir.utility.adapter.dstu3.AdapterFactory();
            case FhirVersionEnum.R4 -> new org.opencds.cqf.fhir.utility.adapter.r4.AdapterFactory();
            case FhirVersionEnum.R5 -> new AdapterFactory();
            default -> throw new IllegalArgumentException("Unsupported FHIR version: %s".formatted(fhirVersion.toString()));
        };
    }

    public static IResourceAdapter createAdapterForResource(IBaseResource resource) {
        return IAdapterFactory.forFhirVersion(resource.getStructureFhirVersionEnum()).createResource(resource);
    }

    public static IAdapter<IBase> createAdapterForBase(FhirVersionEnum fhirVersion, IBase element) {
        return IAdapterFactory.forFhirVersion(fhirVersion).createBase(element);
    }

    public IResourceAdapter createResource(IBaseResource var1);

    public IAdapter<IBase> createBase(IBase var1);

    public IKnowledgeArtifactAdapter createKnowledgeArtifactAdapter(IDomainResource var1);

    public ILibraryAdapter createLibrary(IBaseResource var1);

    public IPlanDefinitionAdapter createPlanDefinition(IBaseResource var1);

    public IActivityDefinitionAdapter createActivityDefinition(IBaseResource var1);

    public IAttachmentAdapter createAttachment(IBase var1);

    public IParametersAdapter createParameters(IBaseParameters var1);

    public IParametersParameterComponentAdapter createParametersParameter(IBase var1);

    public IEndpointAdapter createEndpoint(IBaseResource var1);

    public ICodeableConceptAdapter createCodeableConcept(IBase var1);

    public ICodingAdapter createCoding(IBase var1);

    public IElementDefinitionAdapter createElementDefinition(IBase var1);

    public IRequestActionAdapter createRequestAction(IBase var1);

    public IDataRequirementAdapter createDataRequirement(IBase var1);

    public IQuestionnaireAdapter createQuestionnaire(IBaseResource var1);

    public IQuestionnaireItemComponentAdapter createQuestionnaireItem();

    public IQuestionnaireItemComponentAdapter createQuestionnaireItem(IBase var1);

    public IQuestionnaireResponseAdapter createQuestionnaireResponse(IBaseResource var1);

    public IQuestionnaireResponseItemComponentAdapter createQuestionnaireResponseItem(IBase var1);

    public IQuestionnaireResponseItemAnswerComponentAdapter createQuestionnaireResponseItemAnswer(IBase var1);

    public IValueSetAdapter createValueSet(IBaseResource var1);

    public IGraphDefinitionAdapter createGraphDefinition(IBaseResource var1);

    public IStructureDefinitionAdapter createStructureDefinition(IBaseResource var1);

    public ITupleAdapter createTuple(IBase var1);
}

