/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.util.ParametersUtil;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.fhir.utility.adapter.IDataRequirementAdapter;
import org.opencds.cqf.fhir.utility.adapter.IKnowledgeArtifactAdapter;

public interface ILibraryAdapter
extends IKnowledgeArtifactAdapter {
    public boolean hasContent();

    public <T extends ICompositeType> List<T> getContent();

    public void setContent(List<? extends ICompositeType> var1);

    public ICompositeType addContent();

    public ICompositeType getType();

    public ILibraryAdapter setType(String var1);

    public <T extends ICompositeType> List<T> getParameter();

    public boolean hasDataRequirement();

    public List<IDataRequirementAdapter> getDataRequirement();

    public ILibraryAdapter addDataRequirement(ICompositeType var1);

    public <T extends ICompositeType> ILibraryAdapter setDataRequirement(List<T> var1);

    public void setExpansionParameters(IBaseParameters var1);

    default public void ensureExpansionParametersEntry(IKnowledgeArtifactAdapter artifactAdapter, String crmiVersion) {
        Optional<IBaseParameters> maybeExpansionParameters = this.getExpansionParameters();
        if (maybeExpansionParameters.isPresent()) {
            IBaseParameters expansionParameters = maybeExpansionParameters.get();
            String resourceType = artifactAdapter.get().fhirType();
            String url = artifactAdapter.getUrl();
            String canonical = url + "|" + artifactAdapter.getVersion();
            String parameterName = this.getExpansionParameterName(resourceType, crmiVersion);
            if (!this.parameterExists(expansionParameters, parameterName, canonical)) {
                IPrimitiveType<String> canonicalToAdd = this.buildCanonicalToAdd(artifactAdapter, crmiVersion, resourceType, canonical, this.fhirContext());
                ParametersUtil.addParameterToParameters((FhirContext)this.fhirContext(), (IBaseParameters)expansionParameters, (String)parameterName, canonicalToAdd);
            }
        }
    }

    default public boolean parameterExists(IBaseParameters parameters, String parameterName, String canonical) {
        if (parameters == null) {
            return false;
        }
        List nameMatchedParameters = ParametersUtil.getNamedParameterValuesAsString((FhirContext)this.fhirContext(), (IBaseParameters)parameters, (String)parameterName);
        return nameMatchedParameters.stream().anyMatch(p -> p.equals(canonical));
    }

    private IPrimitiveType<String> buildCanonicalToAdd(IKnowledgeArtifactAdapter artifactAdapter, String crmiVersion, String resourceType, String canonical, FhirContext ctx) {
        IPrimitiveType canonicalToAdd = (IPrimitiveType)ctx.getElementDefinition("canonical").newInstance();
        canonicalToAdd.setValueAsString(canonical);
        if (canonicalToAdd instanceof IBaseHasExtensions) {
            IBaseHasExtensions hasExtensions = (IBaseHasExtensions)canonicalToAdd;
            List extensions = hasExtensions.getExtension();
            if (this.shouldAddResourceTypeExtension(crmiVersion, resourceType)) {
                IBaseExtension resourceTypeExt = (IBaseExtension)ctx.getElementDefinition("Extension").newInstance();
                resourceTypeExt.setUrl("http://hl7.org/fhir/StructureDefinition/cqf-resourceType");
                IPrimitiveType codeValue = (IPrimitiveType)ctx.getElementDefinition("code").newInstance();
                codeValue.setValueAsString(resourceType);
                resourceTypeExt.setValue((IBaseDatatype)codeValue);
                extensions.add(resourceTypeExt);
            }
            IBaseExtension displayExt = (IBaseExtension)ctx.getElementDefinition("Extension").newInstance();
            displayExt.setUrl("http://hl7.org/fhir/StructureDefinition/display");
            IPrimitiveType displayValue = (IPrimitiveType)ctx.getElementDefinition("string").newInstance();
            displayValue.setValueAsString(artifactAdapter.getDescriptor());
            displayExt.setValue((IBaseDatatype)displayValue);
            extensions.add(displayExt);
        }
        return canonicalToAdd;
    }

    default public String getExpansionParameterName(String resourceType, String crmiVersion) {
        boolean isCrmiV1;
        if (StringUtils.isBlank((CharSequence)resourceType)) {
            throw new IllegalArgumentException("Missing required parameter: 'resourceType'");
        }
        boolean bl = isCrmiV1 = crmiVersion != null && crmiVersion.equals("1.0.0");
        if (resourceType.equals("CodeSystem")) {
            return isCrmiV1 ? "system-version" : "default-system-version";
        }
        if (resourceType.equals("ValueSet")) {
            return isCrmiV1 ? "canonicalVersion" : "default-valueset-version";
        }
        return isCrmiV1 ? "canonicalVersion" : "default-canonical-version";
    }

    default public boolean shouldAddResourceTypeExtension(String crmiVersion, String resourceType) {
        boolean isV1AndQualifies = (crmiVersion == null || crmiVersion.equals("1.0.0")) && !resourceType.equals("CodeSystem");
        boolean isV2AndQualifies = crmiVersion != null && !crmiVersion.equals("1.0.0") && resourceType.equals("ValueSet");
        return isV1AndQualifies || isV2AndQualifies;
    }
}

