/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.opencds.cqf.fhir.utility.adapter.IItemComponentAdapter;
import org.opencds.cqf.fhir.utility.adapter.IKnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.adapter.IQuestionnaireItemComponentAdapter;

public interface IQuestionnaireAdapter
extends IKnowledgeArtifactAdapter {
    public boolean hasItem();

    public List<IQuestionnaireItemComponentAdapter> getItem();

    public void setItem(List<IQuestionnaireItemComponentAdapter> var1);

    public void addItem(IBaseBackboneElement var1);

    public void addItem(IQuestionnaireItemComponentAdapter var1);

    public void addItems(List<IQuestionnaireItemComponentAdapter> var1);

    default public Set<String> getAllItemDefinitions() {
        return this.getItemDefs(this.getItem());
    }

    default public Set<String> getItemDefs(List<? extends IItemComponentAdapter> items) {
        HashSet<String> defs = new HashSet<String>();
        items.forEach(item -> {
            if (item.hasDefinition()) {
                defs.add(item.getDefinition());
            }
            if (item.hasItem()) {
                defs.addAll(this.getItemDefs(item.getItem()));
            }
        });
        return defs;
    }
}

