/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.fhir.utility.adapter.IElementDefinitionAdapter;
import org.opencds.cqf.fhir.utility.adapter.IKnowledgeArtifactAdapter;

public interface IStructureDefinitionAdapter
extends IKnowledgeArtifactAdapter {
    default public String getType() {
        return this.resolvePathString((IBase)this.get(), "type");
    }

    public IPrimitiveType<String> getBaseDefinition();

    public boolean hasSnapshot();

    public List<IElementDefinitionAdapter> getSnapshotElements();

    public List<IElementDefinitionAdapter> getDifferentialElements();

    default public IElementDefinitionAdapter getElement(String elementId) {
        return this.getDifferentialElements().stream().filter(e -> e.getId().equals(elementId)).findFirst().orElseGet(() -> this.getSnapshotElements().stream().filter(e -> e.getId().equals(elementId)).findFirst().orElse(null));
    }

    default public IElementDefinitionAdapter getElementByPath(String path) {
        return this.getDifferentialElements().stream().filter(e -> !e.hasSlicing()).filter(e -> path.equals(e.getPath().substring(e.getPath().indexOf(".") + 1))).findFirst().orElseGet(() -> this.getSnapshotElements().stream().filter(e -> !e.hasSlicing()).filter(e -> path.equals(e.getPath().substring(e.getPath().indexOf(".") + 1))).findFirst().orElse(null));
    }

    default public List<IElementDefinitionAdapter> getSliceElements(String sliceName) {
        return this.getDifferentialElements().stream().filter(e -> e.getId().contains(sliceName) && StringUtils.isBlank((CharSequence)e.getSliceName())).toList();
    }
}

