/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.dstu3;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hl7.fhir.dstu3.model.ActivityDefinition;
import org.hl7.fhir.dstu3.model.MetadataResource;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedArtifact;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.adapter.DependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.IActivityDefinitionAdapter;
import org.opencds.cqf.fhir.utility.adapter.IDependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.dstu3.KnowledgeArtifactAdapter;

public class ActivityDefinitionAdapter
extends KnowledgeArtifactAdapter
implements IActivityDefinitionAdapter {
    public ActivityDefinitionAdapter(IDomainResource activityDefinition) {
        super(activityDefinition);
        if (!(activityDefinition instanceof ActivityDefinition)) {
            throw new IllegalArgumentException("resource passed as activityDefinition argument is not an ActivityDefinition resource");
        }
    }

    public ActivityDefinitionAdapter(ActivityDefinition activityDefinition) {
        super((MetadataResource)activityDefinition);
    }

    protected ActivityDefinition getActivityDefinition() {
        return (ActivityDefinition)this.resource;
    }

    @Override
    public ActivityDefinition get() {
        return this.getActivityDefinition();
    }

    public ActivityDefinition copy() {
        return this.get().copy();
    }

    @Override
    public List<IDependencyInfo> getDependencies() {
        ArrayList<IDependencyInfo> references = new ArrayList<IDependencyInfo>();
        String referenceSource = this.getReferenceSource();
        this.addProfileReferences(references, referenceSource);
        this.getRelatedArtifactsOfType("depends-on").stream().filter(RelatedArtifact::hasResource).map(ra -> DependencyInfo.convertRelatedArtifact((ICompositeType)ra, referenceSource)).forEach(references::add);
        if (this.hasLibrary()) {
            for (Reference reference : this.getActivityDefinition().getLibrary()) {
                references.add(new DependencyInfo(referenceSource, reference.getReference(), reference.getExtension(), arg_0 -> ((Reference)reference).setReference(arg_0)));
            }
        }
        return references;
    }

    @Override
    public Map<String, String> getReferencedLibraries() {
        Map<String, String> libraries = this.getActivityDefinition().getLibrary().stream().collect(Collectors.toMap(l -> Objects.requireNonNull(Canonicals.getIdPart(l.getReference())), Reference::getReference));
        libraries.putAll(this.resolveCqfLibraries());
        return libraries;
    }

    @Override
    public String getDescription() {
        return this.get().getDescription();
    }

    @Override
    public boolean hasLibrary() {
        return this.get().hasLibrary();
    }

    @Override
    public List<String> getLibrary() {
        return this.get().getLibrary().stream().map(Reference::getReference).toList();
    }
}

