/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.dstu3;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.dstu3.model.DataRequirement;
import org.hl7.fhir.instance.model.api.IBase;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.utility.adapter.BaseAdapter;
import org.opencds.cqf.fhir.utility.adapter.IDataRequirementAdapter;
import org.opencds.cqf.fhir.utility.adapter.IDataRequirementCodeFilterAdapter;
import org.opencds.cqf.fhir.utility.adapter.dstu3.DataRequirementCodeFilterAdapter;

public class DataRequirementAdapter
extends BaseAdapter
implements IDataRequirementAdapter {
    private final DataRequirement dataRequirement;

    public DataRequirementAdapter(IBase compositeType) {
        super(FhirVersionEnum.DSTU3, compositeType);
        if (!(compositeType instanceof DataRequirement)) {
            throw new IllegalArgumentException("object passed as dataRequirement argument is not a DataRequirement data type");
        }
        DataRequirement dataRequirementInner = (DataRequirement)compositeType;
        this.dataRequirement = dataRequirementInner;
    }

    @Override
    public DataRequirement get() {
        return this.dataRequirement;
    }

    @Override
    public FhirContext fhirContext() {
        return this.fhirContext;
    }

    @Override
    public ModelResolver getModelResolver() {
        return this.modelResolver;
    }

    @Override
    public boolean hasId() {
        return this.get().hasId();
    }

    @Override
    public String getId() {
        return this.get().getId();
    }

    @Override
    public boolean hasType() {
        return this.get().hasType();
    }

    @Override
    public String getType() {
        return this.get().getType();
    }

    @Override
    public boolean hasCodeFilter() {
        return this.get().hasCodeFilter();
    }

    @Override
    public List<IDataRequirementCodeFilterAdapter> getCodeFilter() {
        return this.get().getCodeFilter().stream().map(DataRequirementCodeFilterAdapter::new).collect(Collectors.toUnmodifiableList());
    }
}

