/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.dstu3;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.dstu3.model.DataRequirement;
import org.hl7.fhir.dstu3.model.Extension;
import org.hl7.fhir.dstu3.model.MetadataResource;
import org.hl7.fhir.dstu3.model.PlanDefinition;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedArtifact;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.TriggerDefinition;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.adapter.DependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.IDependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.IPlanDefinitionActionAdapter;
import org.opencds.cqf.fhir.utility.adapter.IPlanDefinitionAdapter;
import org.opencds.cqf.fhir.utility.adapter.dstu3.KnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.adapter.dstu3.PlanDefinitionActionAdapter;

class PlanDefinitionAdapter
extends KnowledgeArtifactAdapter
implements IPlanDefinitionAdapter {
    public PlanDefinitionAdapter(IDomainResource planDefinition) {
        super(planDefinition);
        if (!(planDefinition instanceof PlanDefinition)) {
            throw new IllegalArgumentException("resource passed as planDefinition argument is not a PlanDefinition resource");
        }
    }

    public PlanDefinitionAdapter(PlanDefinition planDefinition) {
        super((MetadataResource)planDefinition);
    }

    protected PlanDefinition getPlanDefinition() {
        return (PlanDefinition)this.resource;
    }

    @Override
    public PlanDefinition get() {
        return this.getPlanDefinition();
    }

    public PlanDefinition copy() {
        return this.get().copy();
    }

    @Override
    public List<IDependencyInfo> getDependencies() {
        ArrayList<IDependencyInfo> references = new ArrayList<IDependencyInfo>();
        String referenceSource = this.getReferenceSource();
        this.addProfileReferences(references, referenceSource);
        this.getRelatedArtifactsOfType("depends-on").stream().filter(RelatedArtifact::hasResource).map(ra -> DependencyInfo.convertRelatedArtifact((ICompositeType)ra, referenceSource)).forEach(references::add);
        List libraries = this.getPlanDefinition().getLibrary();
        for (Reference ref : libraries) {
            DependencyInfo dependency = new DependencyInfo(referenceSource, ref.getReference(), ref.getExtension(), arg_0 -> ((Reference)ref).setReference(arg_0));
            references.add(dependency);
        }
        this.getPlanDefinition().getAction().forEach(action -> this.getDependenciesOfAction((PlanDefinition.PlanDefinitionActionComponent)action, (List<IDependencyInfo>)references, referenceSource));
        this.getPlanDefinition().getExtension().stream().filter(ext -> ext.getUrl().contains("cpg-partOf")).filter(Extension::hasValue).findAny().ifPresent(ext -> {
            UriType reference = (UriType)ext.getValue();
            references.add(new DependencyInfo(referenceSource, (String)reference.getValue(), ext.getExtension(), arg_0 -> ((UriType)reference).setValue(arg_0)));
        });
        return references;
    }

    private void getDependenciesOfAction(PlanDefinition.PlanDefinitionActionComponent action, List<IDependencyInfo> references, String referenceSource) {
        action.getTriggerDefinition().stream().map(TriggerDefinition::getEventData).forEach(eventData -> {
            eventData.getProfile().stream().filter(PrimitiveType::hasValue).forEach(profile -> references.add(new DependencyInfo(referenceSource, (String)profile.getValue(), profile.getExtension(), arg_0 -> ((UriType)profile).setValue(arg_0))));
            eventData.getCodeFilter().stream().filter(DataRequirement.DataRequirementCodeFilterComponent::hasValueSet).forEach(cf -> references.add(this.dependencyFromDataRequirementCodeFilter((DataRequirement.DataRequirementCodeFilterComponent)cf)));
        });
        Stream.concat(action.getInput().stream(), action.getOutput().stream()).forEach(inputOrOutput -> {
            inputOrOutput.getProfile().stream().filter(PrimitiveType::hasValue).forEach(profile -> references.add(new DependencyInfo(referenceSource, (String)profile.getValue(), profile.getExtension(), arg_0 -> ((UriType)profile).setValue(arg_0))));
            inputOrOutput.getCodeFilter().stream().filter(DataRequirement.DataRequirementCodeFilterComponent::hasValueSet).forEach(cf -> references.add(this.dependencyFromDataRequirementCodeFilter((DataRequirement.DataRequirementCodeFilterComponent)cf)));
        });
        Reference definition = action.getDefinition();
        if (definition != null && definition.hasReference()) {
            references.add(new DependencyInfo(referenceSource, definition.getReference(), definition.getExtension(), arg_0 -> ((Reference)definition).setReference(arg_0)));
        }
        action.getAction().forEach(nestedAction -> this.getDependenciesOfAction((PlanDefinition.PlanDefinitionActionComponent)nestedAction, references, referenceSource));
    }

    private DependencyInfo dependencyFromDataRequirementCodeFilter(DataRequirement.DataRequirementCodeFilterComponent cf) {
        Type vs = cf.getValueSet();
        if (vs instanceof StringType) {
            StringType stringType = (StringType)vs;
            return new DependencyInfo(this.getPlanDefinition().getUrl(), (String)stringType.getValue(), vs.getExtension(), arg_0 -> ((StringType)stringType).setValue(arg_0));
        }
        if (vs instanceof Reference) {
            Reference reference = (Reference)vs;
            return new DependencyInfo(this.getPlanDefinition().getUrl(), reference.getReference(), vs.getExtension(), arg_0 -> ((Reference)reference).setReference(arg_0));
        }
        return null;
    }

    @Override
    public Map<String, String> getReferencedLibraries() {
        Map<String, String> libraries = this.getPlanDefinition().getLibrary().stream().collect(Collectors.toMap(l -> Objects.requireNonNull(Canonicals.getIdPart(l.getReference())), Reference::getReference));
        libraries.putAll(this.resolveCqfLibraries());
        return libraries;
    }

    @Override
    public String getDescription() {
        return this.get().getDescription();
    }

    @Override
    public boolean hasLibrary() {
        return this.get().hasLibrary();
    }

    @Override
    public List<String> getLibrary() {
        return this.get().getLibrary().stream().map(Reference::getReference).collect(Collectors.toList());
    }

    @Override
    public boolean hasAction() {
        return this.get().hasAction();
    }

    @Override
    public List<IPlanDefinitionActionAdapter> getAction() {
        return this.get().getAction().stream().map(PlanDefinitionActionAdapter::new).collect(Collectors.toList());
    }
}

