/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.dstu3;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.dstu3.model.QuestionnaireResponse;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.fhir.utility.adapter.IAdapter;
import org.opencds.cqf.fhir.utility.adapter.IQuestionnaireResponseAdapter;
import org.opencds.cqf.fhir.utility.adapter.IQuestionnaireResponseItemComponentAdapter;
import org.opencds.cqf.fhir.utility.adapter.dstu3.ResourceAdapter;

public class QuestionnaireResponseAdapter
extends ResourceAdapter
implements IQuestionnaireResponseAdapter {
    public QuestionnaireResponseAdapter(IDomainResource questionnaireResponse) {
        super((IBaseResource)questionnaireResponse);
        if (!(questionnaireResponse instanceof QuestionnaireResponse)) {
            throw new IllegalArgumentException("resource passed as questionnaire argument is not a QuestionnaireResponse resource");
        }
    }

    public QuestionnaireResponseAdapter(QuestionnaireResponse questionnaireResponse) {
        super((IBaseResource)questionnaireResponse);
    }

    protected QuestionnaireResponse getQuestionnaireResponse() {
        return (QuestionnaireResponse)this.resource;
    }

    @Override
    public QuestionnaireResponse get() {
        return this.getQuestionnaireResponse();
    }

    @Override
    public IQuestionnaireResponseAdapter setId(String id) {
        this.get().setId(id);
        return this;
    }

    @Override
    public IQuestionnaireResponseAdapter setQuestionnaire(String canonical) {
        this.get().setQuestionnaire(new Reference(canonical));
        return this;
    }

    @Override
    public IQuestionnaireResponseAdapter setSubject(IIdType subject) {
        this.get().setSubject(new Reference(subject));
        return this;
    }

    @Override
    public IQuestionnaireResponseAdapter setAuthored(Date date) {
        this.get().setAuthored(date);
        return this;
    }

    @Override
    public IQuestionnaireResponseAdapter setStatus(String status) {
        this.get().setStatus(QuestionnaireResponse.QuestionnaireResponseStatus.fromCode((String)status));
        return this;
    }

    @Override
    public boolean hasItem() {
        return this.getQuestionnaireResponse().hasItem();
    }

    @Override
    public List<IQuestionnaireResponseItemComponentAdapter> getItem() {
        return this.getQuestionnaireResponse().getItem().stream().map(this.adapterFactory::createQuestionnaireResponseItem).toList();
    }

    @Override
    public void setItem(List<IQuestionnaireResponseItemComponentAdapter> items) {
        this.getQuestionnaireResponse().setItem(items.stream().map(IAdapter::get).map(QuestionnaireResponse.QuestionnaireResponseItemComponent.class::cast).collect(Collectors.toList()));
    }

    @Override
    public void addItem(IQuestionnaireResponseItemComponentAdapter item) {
        this.getQuestionnaireResponse().addItem((QuestionnaireResponse.QuestionnaireResponseItemComponent)item.get());
    }

    @Override
    public void addItems(List<IQuestionnaireResponseItemComponentAdapter> items) {
        items.stream().map(IAdapter::get).map(QuestionnaireResponse.QuestionnaireResponseItemComponent.class::cast).forEach(item -> this.getQuestionnaireResponse().addItem(item));
    }
}

