/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.r4;

import ca.uhn.fhir.context.FhirVersionEnum;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.r4.model.Coding;
import org.opencds.cqf.fhir.utility.adapter.BaseAdapter;
import org.opencds.cqf.fhir.utility.adapter.ICodingAdapter;

public class CodingAdapter
extends BaseAdapter
implements ICodingAdapter {
    private final Coding coding;

    public CodingAdapter(IBase coding) {
        super(FhirVersionEnum.R4, coding);
        if (!(coding instanceof Coding)) {
            throw new IllegalArgumentException("object passed as coding argument is not a Coding data type");
        }
        this.coding = (Coding)coding;
    }

    @Override
    public Coding get() {
        return this.coding;
    }

    @Override
    public String getCode() {
        return this.get().getCode();
    }

    @Override
    public boolean hasCode() {
        return this.get().hasCode();
    }

    @Override
    public ICodingAdapter setCode(String code) {
        this.get().setCode(code);
        return this;
    }

    @Override
    public String getDisplay() {
        return this.get().getDisplay();
    }

    @Override
    public boolean hasDisplay() {
        return this.get().hasDisplay();
    }

    @Override
    public ICodingAdapter setDisplay(String display) {
        this.get().setDisplay(display);
        return this;
    }

    @Override
    public String getSystem() {
        return this.get().getSystem();
    }

    @Override
    public boolean hasSystem() {
        return this.get().hasSystem();
    }

    @Override
    public ICodingAdapter setSystem(String system) {
        this.get().setSystem(system);
        return this;
    }
}

