/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.r4;

import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseDatatypeElement;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.opencds.cqf.fhir.utility.adapter.BaseAdapter;
import org.opencds.cqf.fhir.utility.adapter.ICodingAdapter;
import org.opencds.cqf.fhir.utility.adapter.IElementDefinitionAdapter;

public class ElementDefinitionAdapter
extends BaseAdapter
implements IElementDefinitionAdapter {
    private final ElementDefinition elementDefinition;

    public ElementDefinitionAdapter(IBase elementDefinition) {
        super(FhirVersionEnum.R4, elementDefinition);
        if (!(elementDefinition instanceof ElementDefinition)) {
            throw new IllegalArgumentException("object passed as elementDefinition argument is not a ElementDefinition data type");
        }
        this.elementDefinition = (ElementDefinition)elementDefinition;
    }

    @Override
    public ElementDefinition get() {
        return this.elementDefinition;
    }

    @Override
    public String getId() {
        return this.get().getId();
    }

    @Override
    public String getPath() {
        return this.get().getPath();
    }

    @Override
    public String getSliceName() {
        return this.get().getSliceName();
    }

    @Override
    public boolean hasSlicing() {
        return this.get().hasSlicing();
    }

    @Override
    public String getLabel() {
        return this.get().getLabel();
    }

    @Override
    public boolean hasLabel() {
        return this.get().hasLabel();
    }

    @Override
    public List<ICodingAdapter> getCode() {
        return this.get().getCode().stream().map(this.adapterFactory::createCoding).toList();
    }

    @Override
    public String getShort() {
        return this.get().getShort();
    }

    @Override
    public boolean hasShort() {
        return this.get().hasShort();
    }

    @Override
    public String getDefinition() {
        return this.get().getDefinition();
    }

    @Override
    public String getComment() {
        return this.get().getComment();
    }

    @Override
    public String getRequirements() {
        return this.get().getRequirements();
    }

    @Override
    public List<String> getAlias() {
        return this.get().getAlias().stream().map(PrimitiveType::asStringValue).toList();
    }

    @Override
    public int getMin() {
        return this.get().getMin();
    }

    @Override
    public boolean hasMin() {
        return this.get().hasMin();
    }

    @Override
    public String getMax() {
        return this.get().getMax();
    }

    @Override
    public boolean hasMax() {
        return this.get().hasMax();
    }

    @Override
    public <T extends IBase> List<T> getType() {
        return this.get().getType().stream().map(t -> t).toList();
    }

    @Override
    public String getTypeCode() {
        ElementDefinition.TypeRefComponent firstType = this.get().getTypeFirstRep();
        Extension typeExt = firstType.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type");
        if (typeExt != null) {
            return typeExt.getValueAsPrimitive().getValueAsString();
        }
        return firstType.getCode();
    }

    @Override
    public String getTypeProfile() {
        return this.get().getTypeFirstRep().getProfile().stream().findFirst().orElse(new CanonicalType()).asStringValue();
    }

    @Override
    public <T extends IBaseDatatype> T getDefaultValue() {
        return (T)this.get().getDefaultValue();
    }

    @Override
    public boolean hasDefaultValue() {
        return this.get().hasDefaultValue();
    }

    @Override
    public <T extends IBaseDatatype> T getFixed() {
        return (T)this.get().getFixed();
    }

    @Override
    public boolean hasFixed() {
        return this.get().hasFixed();
    }

    @Override
    public <T extends IBaseDatatype> T getPattern() {
        return (T)this.get().getPattern();
    }

    @Override
    public boolean hasPattern() {
        return this.get().hasPattern();
    }

    @Override
    public <T extends IBaseDatatype> T getFixedOrPattern() {
        return (T)this.get().getFixedOrPattern();
    }

    @Override
    public boolean hasFixedOrPattern() {
        return this.get().hasFixedOrPattern();
    }

    @Override
    public <T extends IBaseDatatype> T getDefaultOrFixedOrPattern() {
        return this.hasFixedOrPattern() ? this.getFixedOrPattern() : this.getDefaultValue();
    }

    @Override
    public boolean hasDefaultOrFixedOrPattern() {
        return this.hasDefaultValue() || this.hasFixedOrPattern();
    }

    @Override
    public boolean getMustSupport() {
        return this.get().getMustSupport();
    }

    @Override
    public <T extends IBaseDatatypeElement> T getBinding() {
        return (T)this.get().getBinding();
    }

    @Override
    public boolean hasBinding() {
        return this.get().hasBinding();
    }

    @Override
    public String getBindingValueSet() {
        return this.hasBinding() ? this.get().getBinding().getValueSet() : null;
    }
}

