/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.r4;

import ca.uhn.fhir.repository.IRepository;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.DataRequirement;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Library;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.ParameterDefinition;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedArtifact;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.Type;
import org.opencds.cqf.fhir.utility.adapter.DependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.IDataRequirementAdapter;
import org.opencds.cqf.fhir.utility.adapter.IDependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.ILibraryAdapter;
import org.opencds.cqf.fhir.utility.adapter.r4.DataRequirementAdapter;
import org.opencds.cqf.fhir.utility.adapter.r4.KnowledgeArtifactAdapter;

public class LibraryAdapter
extends KnowledgeArtifactAdapter
implements ILibraryAdapter {
    public LibraryAdapter(IDomainResource library) {
        super(library);
        if (!(library instanceof Library)) {
            throw new IllegalArgumentException("resource passed as library argument is not a Library resource");
        }
    }

    public LibraryAdapter(Library library) {
        super((MetadataResource)library);
    }

    protected Library getLibrary() {
        return (Library)this.resource;
    }

    @Override
    public Library get() {
        return (Library)this.resource;
    }

    public Library copy() {
        return this.get().copy();
    }

    @Override
    public boolean hasContent() {
        return this.getLibrary().hasContent();
    }

    public List<Attachment> getContent() {
        return this.getLibrary().getContent().stream().toList();
    }

    @Override
    public void setContent(List<? extends ICompositeType> attachments) {
        List castAttachments = attachments.stream().map(x -> (Attachment)x).collect(Collectors.toList());
        this.getLibrary().setContent(castAttachments);
    }

    public Attachment addContent() {
        return this.getLibrary().addContent();
    }

    @Override
    public List<IDependencyInfo> getDependencies() {
        ArrayList<IDependencyInfo> references = new ArrayList<IDependencyInfo>();
        String referenceSource = this.getReferenceSource();
        this.addProfileReferences(references, referenceSource);
        this.getRelatedArtifactsOfType("depends-on").stream().filter(RelatedArtifact::hasResource).map(ra -> DependencyInfo.convertRelatedArtifact((ICompositeType)ra, referenceSource)).forEach(references::add);
        this.getLibrary().getDataRequirement().forEach(dr -> {
            dr.getProfile().stream().filter(IPrimitiveType::hasValue).forEach(profile -> references.add(new DependencyInfo(referenceSource, (String)profile.getValue(), profile.getExtension(), arg_0 -> ((CanonicalType)profile).setValue(arg_0))));
            dr.getCodeFilter().stream().filter(DataRequirement.DataRequirementCodeFilterComponent::hasValueSet).forEach(cf -> references.add(new DependencyInfo(referenceSource, cf.getValueSet(), cf.getExtension(), arg_0 -> ((DataRequirement.DataRequirementCodeFilterComponent)cf).setValueSet(arg_0))));
        });
        return references;
    }

    @Override
    public Map<String, String> getReferencedLibraries() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(this.getName(), this.getCanonical());
        return map;
    }

    @Override
    public Map<String, ILibraryAdapter> retrieveReferencedLibraries(IRepository repository) {
        HashMap<String, ILibraryAdapter> map = new HashMap<String, ILibraryAdapter>();
        map.put(this.getName(), this);
        return map;
    }

    public List<RelatedArtifact> getComponents() {
        return this.getRelatedArtifactsOfType("composed-of");
    }

    @Override
    public ICompositeType getType() {
        return this.getLibrary().getType();
    }

    @Override
    public LibraryAdapter setType(String type) {
        if (!LIBRARY_TYPES.contains(type)) {
            throw new UnprocessableEntityException(new String[]{"Invalid type: {}", type});
        }
        this.getLibrary().setType(new CodeableConcept(new Coding("http://hl7.org/fhir/ValueSet/library-type", type, "")));
        return this;
    }

    public List<ParameterDefinition> getParameter() {
        return this.getLibrary().getParameter();
    }

    @Override
    public boolean hasDataRequirement() {
        return this.getLibrary().hasDataRequirement();
    }

    @Override
    public List<IDataRequirementAdapter> getDataRequirement() {
        return this.getLibrary().getDataRequirement().stream().map(DataRequirementAdapter::new).collect(Collectors.toList());
    }

    @Override
    public LibraryAdapter addDataRequirement(ICompositeType dataRequirement) {
        this.getLibrary().addDataRequirement((DataRequirement)dataRequirement);
        return this;
    }

    @Override
    public <T extends ICompositeType> LibraryAdapter setDataRequirement(List<T> dataRequirement) {
        this.getLibrary().setDataRequirement(dataRequirement.stream().map(dr -> (DataRequirement)dr).collect(Collectors.toList()));
        return this;
    }

    @Override
    public Optional<IBaseParameters> getExpansionParameters() {
        Optional<IBaseParameters> expansionParameters = this.getLibrary().getExtension().stream().filter(ext -> ext.getUrl().equals("http://hl7.org/fhir/StructureDefinition/cqf-expansionParameters")).findAny().map(ext -> ((Reference)ext.getValue()).getReference()).map(ref -> {
            if (this.getLibrary().hasContained()) {
                return this.getLibrary().getContained().stream().filter(containedResource -> ref.equals("#" + containedResource.getId())).filter(IBaseParameters.class::isInstance).map(IBaseParameters.class::cast).findFirst().orElse(null);
            }
            return null;
        });
        if (expansionParameters.isPresent()) {
            return expansionParameters;
        }
        String id = "exp-params";
        Parameters newExpansionParameters = new Parameters();
        newExpansionParameters.setId(id);
        this.getLibrary().addContained((Resource)newExpansionParameters);
        if (this.getLibrary().getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/cqf-expansionParameters") == null) {
            Extension expansionParamsExt = this.getLibrary().addExtension();
            expansionParamsExt.setUrl("http://hl7.org/fhir/StructureDefinition/cqf-expansionParameters");
            expansionParamsExt.setValue((Type)new Reference("#" + id));
        }
        this.setExpansionParameters((IBaseParameters)newExpansionParameters);
        return Optional.of(newExpansionParameters);
    }

    @Override
    public void setExpansionParameters(IBaseParameters expansionParameters) {
        if (expansionParameters != null && !((Parameters)expansionParameters).getParameter().isEmpty()) {
            ArrayList<Parameters.ParametersParameterComponent> newParameters = new ArrayList<Parameters.ParametersParameterComponent>();
            for (Parameters.ParametersParameterComponent parameter : ((Parameters)expansionParameters).getParameter()) {
                Parameters.ParametersParameterComponent param = new Parameters.ParametersParameterComponent();
                param.setName(parameter.getName());
                param.setValue(parameter.getValue());
                newParameters.add(param);
            }
            Optional<IBaseParameters> existingExpansionParameters = this.getExpansionParameters();
            existingExpansionParameters.ifPresent(parameters -> ((Parameters)parameters).setParameter((List)newParameters));
        }
    }
}

