/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.r4;

import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.Tuple;
import org.hl7.fhir.r4.model.Type;
import org.opencds.cqf.fhir.utility.adapter.BaseAdapter;
import org.opencds.cqf.fhir.utility.adapter.IParametersParameterComponentAdapter;

class ParametersParameterComponentAdapter
extends BaseAdapter
implements IParametersParameterComponentAdapter {
    private final Parameters.ParametersParameterComponent parametersParameterComponent;

    protected Parameters.ParametersParameterComponent getParametersParameterComponent() {
        return this.parametersParameterComponent;
    }

    public ParametersParameterComponentAdapter(IBase parametersParameterComponent) {
        super(FhirVersionEnum.R4, parametersParameterComponent);
        if (!parametersParameterComponent.fhirType().equals("Parameters.parameter")) {
            throw new IllegalArgumentException("element passed as parametersParameterComponent argument is not a ParametersParameterComponent Element");
        }
        this.parametersParameterComponent = (Parameters.ParametersParameterComponent)parametersParameterComponent;
    }

    @Override
    public IBaseBackboneElement get() {
        return this.parametersParameterComponent;
    }

    @Override
    public String getName() {
        return this.getParametersParameterComponent().getName();
    }

    @Override
    public void setName(String name) {
        this.getParametersParameterComponent().setName(name);
    }

    @Override
    public List<IParametersParameterComponentAdapter> getPart() {
        return this.getParametersParameterComponent().getPart().stream().map(this.adapterFactory::createParametersParameter).toList();
    }

    @Override
    public List<IBaseDatatype> getPartValues(String name) {
        return this.getParametersParameterComponent().getPart().stream().filter(p -> p.getName().equals(name)).map(Parameters.ParametersParameterComponent::getValue).collect(Collectors.toList());
    }

    @Override
    public void setPart(List<IBaseBackboneElement> parametersParameterComponents) {
        this.getParametersParameterComponent().setPart(parametersParameterComponents == null ? null : parametersParameterComponents.stream().map(x -> (Parameters.ParametersParameterComponent)x).collect(Collectors.toList()));
    }

    @Override
    public IBaseBackboneElement addPart() {
        return this.getParametersParameterComponent().addPart();
    }

    @Override
    public boolean hasPart() {
        return this.getParametersParameterComponent().hasPart();
    }

    @Override
    public boolean hasResource() {
        return this.getParametersParameterComponent().hasResource();
    }

    @Override
    public IBaseResource getResource() {
        return this.getParametersParameterComponent().getResource();
    }

    @Override
    public void setResource(IBaseResource resource) {
        this.getParametersParameterComponent().setResource((Resource)resource);
    }

    @Override
    public boolean hasValue() {
        return this.getParametersParameterComponent().hasValue();
    }

    @Override
    public boolean hasPrimitiveValue() {
        return this.hasValue() && this.getValue() instanceof IPrimitiveType;
    }

    @Override
    public void setValue(IBaseDatatype value) {
        this.getParametersParameterComponent().setValue((Type)value);
    }

    @Override
    public IBaseDatatype getValue() {
        return this.getParametersParameterComponent().getValue();
    }

    @Override
    public String getPrimitiveValue() {
        return this.hasPrimitiveValue() ? this.getParametersParameterComponent().getValue().primitiveValue() : null;
    }

    @Override
    public IBase newTupleWithParts() {
        Tuple tuple = new Tuple();
        this.getPart().forEach(p -> tuple.addProperty(p.getName(), List.of((Base)p.getPartValue((IParametersParameterComponentAdapter)p))));
        return tuple;
    }
}

