/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.r4;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Expression;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.Type;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.utility.adapter.BaseAdapter;
import org.opencds.cqf.fhir.utility.adapter.IAdapter;
import org.opencds.cqf.fhir.utility.adapter.ICodingAdapter;
import org.opencds.cqf.fhir.utility.adapter.IItemComponentAdapter;
import org.opencds.cqf.fhir.utility.adapter.IQuestionnaireItemComponentAdapter;
import org.opencds.cqf.fhir.utility.adapter.IQuestionnaireResponseItemComponentAdapter;

public class QuestionnaireItemComponentAdapter
extends BaseAdapter
implements IQuestionnaireItemComponentAdapter {
    private final Questionnaire.QuestionnaireItemComponent item;

    public QuestionnaireItemComponentAdapter(IBase item) {
        super(FhirVersionEnum.R4, item);
        if (!(item instanceof Questionnaire.QuestionnaireItemComponent)) {
            throw new IllegalArgumentException("object passed as item argument is not a QuestionnaireItemComponent data type");
        }
        this.item = (Questionnaire.QuestionnaireItemComponent)item;
    }

    @Override
    public Questionnaire.QuestionnaireItemComponent get() {
        return this.item;
    }

    @Override
    public FhirContext fhirContext() {
        return this.fhirContext;
    }

    @Override
    public ModelResolver getModelResolver() {
        return this.modelResolver;
    }

    @Override
    public String getLinkId() {
        return this.item.getLinkId();
    }

    @Override
    public IQuestionnaireItemComponentAdapter setLinkId(String linkId) {
        this.get().setLinkId(linkId);
        return this;
    }

    @Override
    public boolean hasDefinition() {
        return this.item.hasDefinition();
    }

    @Override
    public String getDefinition() {
        return this.item.getDefinition();
    }

    @Override
    public IQuestionnaireItemComponentAdapter setDefinition(String definition) {
        this.item.setDefinition(definition);
        return this;
    }

    @Override
    public boolean hasItem() {
        return this.item.hasItem();
    }

    public List<IQuestionnaireItemComponentAdapter> getItem() {
        return this.item.getItem().stream().map(this.adapterFactory::createQuestionnaireItem).toList();
    }

    @Override
    public void setItem(List<? extends IItemComponentAdapter> items) {
        this.item.setItem(items.stream().map(IAdapter::get).map(Questionnaire.QuestionnaireItemComponent.class::cast).collect(Collectors.toList()));
    }

    @Override
    public void addItem(IItemComponentAdapter item) {
        this.item.addItem((Questionnaire.QuestionnaireItemComponent)item.get());
    }

    @Override
    public void addItems(List<IQuestionnaireItemComponentAdapter> items) {
        items.stream().map(IAdapter::get).map(Questionnaire.QuestionnaireItemComponent.class::cast).forEach(arg_0 -> ((Questionnaire.QuestionnaireItemComponent)this.item).addItem(arg_0));
    }

    @Override
    public List<IBaseCoding> getCode() {
        return this.item.getCode().stream().map(IBaseCoding.class::cast).toList();
    }

    @Override
    public String getText() {
        return this.item.getText();
    }

    @Override
    public IQuestionnaireItemComponentAdapter setText(String text) {
        this.item.setText(text);
        return this;
    }

    @Override
    public String getType() {
        return this.item.getType().toCode();
    }

    @Override
    public IQuestionnaireItemComponentAdapter setType(String type) {
        this.item.setType(Questionnaire.QuestionnaireItemType.fromCode((String)type));
        return this;
    }

    @Override
    public boolean isGroupItem() {
        return this.item.getType().equals((Object)Questionnaire.QuestionnaireItemType.GROUP);
    }

    @Override
    public boolean isChoiceItem() {
        return this.item.getType().equals((Object)Questionnaire.QuestionnaireItemType.CHOICE);
    }

    @Override
    public boolean getRequired() {
        return this.item.getRequired();
    }

    @Override
    public IQuestionnaireItemComponentAdapter setRequired(boolean required) {
        this.get().setRequired(required);
        return this;
    }

    @Override
    public boolean getRepeats() {
        return this.item.getRepeats();
    }

    @Override
    public IQuestionnaireItemComponentAdapter setRepeats(boolean repeats) {
        this.get().setRepeats(repeats);
        return this;
    }

    @Override
    public void addAnswerOption(ICodingAdapter option) {
        this.get().addAnswerOption().setValue((Type)((Coding)option.get()));
    }

    @Override
    public boolean hasInitial() {
        return this.item.hasInitial();
    }

    public List<Type> getInitial() {
        return this.item.getInitial().stream().map(Questionnaire.QuestionnaireItemInitialComponent::getValue).toList();
    }

    @Override
    public IQuestionnaireResponseItemComponentAdapter newResponseItem() {
        return this.adapterFactory.createQuestionnaireResponseItem((IBase)new QuestionnaireResponse.QuestionnaireResponseItemComponent().setLinkId(this.item.getLinkId()).setDefinitionElement(this.item.getDefinitionElement()).setTextElement(this.item.getTextElement()));
    }

    @Override
    public ICompositeType newExpression(String language, String expression) {
        return new Expression().setLanguage(language).setExpression(expression);
    }
}

