/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.r4;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.Expression;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.opencds.cqf.fhir.utility.adapter.DependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.IDependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.IElementDefinitionAdapter;
import org.opencds.cqf.fhir.utility.adapter.IStructureDefinitionAdapter;
import org.opencds.cqf.fhir.utility.adapter.r4.KnowledgeArtifactAdapter;

public class StructureDefinitionAdapter
extends KnowledgeArtifactAdapter
implements IStructureDefinitionAdapter {
    public StructureDefinitionAdapter(IDomainResource structureDefinition) {
        super(structureDefinition);
        if (!(structureDefinition instanceof StructureDefinition)) {
            throw new IllegalArgumentException("resource passed as planDefinition argument is not a StructureDefinition resource");
        }
    }

    public StructureDefinitionAdapter(StructureDefinition structureDefinition) {
        super((MetadataResource)structureDefinition);
    }

    protected StructureDefinition getStructureDefinition() {
        return (StructureDefinition)this.resource;
    }

    @Override
    public List<IDependencyInfo> getDependencies() {
        ArrayList<IDependencyInfo> references = new ArrayList<IDependencyInfo>();
        String referenceSource = this.getReferenceSource();
        this.addProfileReferences(references, referenceSource);
        if (this.get().hasBaseDefinition()) {
            references.add(new DependencyInfo(referenceSource, this.get().getBaseDefinition(), this.get().getBaseDefinitionElement().getExtension(), reference -> this.get().setBaseDefinition(reference)));
        }
        this.get().getExtensionsByUrl("http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-assertionExpression").stream().filter(e -> e.getValue() instanceof Expression).map(e -> (Expression)e.getValue()).filter(Expression::hasReference).forEach(expression -> references.add(new DependencyInfo(referenceSource, expression.getReference(), expression.getExtension(), arg_0 -> ((Expression)expression).setReference(arg_0))));
        this.get().getExtensionsByUrl("http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-featureExpression").stream().filter(e -> e.getValue() instanceof Expression).map(e -> (Expression)e.getValue()).filter(Expression::hasReference).forEach(expression -> references.add(new DependencyInfo(referenceSource, expression.getReference(), expression.getExtension(), arg_0 -> ((Expression)expression).setReference(arg_0))));
        this.get().getExtensionsByUrl("http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-inferenceExpression").stream().filter(e -> e.getValue() instanceof Expression).map(e -> (Expression)e.getValue()).filter(Expression::hasReference).forEach(expression -> references.add(new DependencyInfo(referenceSource, expression.getReference(), expression.getExtension(), arg_0 -> ((Expression)expression).setReference(arg_0))));
        this.get().getDifferential().getElement().forEach(element -> this.getDependenciesOfDifferential((ElementDefinition)element, (List<IDependencyInfo>)references, referenceSource));
        return references;
    }

    private void getDependenciesOfDifferential(ElementDefinition element, List<IDependencyInfo> references, String referenceSource) {
        element.getType().forEach(type -> {
            type.getProfile().forEach(profile -> references.add(new DependencyInfo(referenceSource, profile.getValueAsString(), profile.getExtension(), arg_0 -> ((CanonicalType)profile).setValue(arg_0))));
            type.getTargetProfile().forEach(profile -> references.add(new DependencyInfo(referenceSource, profile.getValueAsString(), profile.getExtension(), arg_0 -> ((CanonicalType)profile).setValue(arg_0))));
        });
        if (element.getBinding().hasValueSet()) {
            references.add(new DependencyInfo(referenceSource, element.getBinding().getValueSet(), element.getBinding().getExtension(), reference -> element.getBinding().setValueSet(reference)));
        }
    }

    @Override
    public StructureDefinition get() {
        return this.getStructureDefinition();
    }

    public StructureDefinition copy() {
        return this.get().copy();
    }

    @Override
    public IPrimitiveType<String> getBaseDefinition() {
        return this.get().getBaseDefinitionElement();
    }

    @Override
    public boolean hasSnapshot() {
        return this.get().hasSnapshot();
    }

    @Override
    public List<IElementDefinitionAdapter> getSnapshotElements() {
        return this.get().getSnapshot().getElement().stream().filter(ElementDefinition::hasPath).filter(e -> e.getPath().split("\\.").length > 1).map(this.adapterFactory::createElementDefinition).toList();
    }

    @Override
    public List<IElementDefinitionAdapter> getDifferentialElements() {
        return this.get().getDifferential().getElement().stream().filter(ElementDefinition::hasPath).filter(e -> e.getPath().split("\\.").length > 1).map(this.adapterFactory::createElementDefinition).toList();
    }
}

