/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.r5;

import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.r5.model.DataRequirement;
import org.opencds.cqf.fhir.utility.adapter.BaseAdapter;
import org.opencds.cqf.fhir.utility.adapter.IDataRequirementAdapter;
import org.opencds.cqf.fhir.utility.adapter.IDataRequirementCodeFilterAdapter;
import org.opencds.cqf.fhir.utility.adapter.r5.DataRequirementCodeFilterAdapter;

public class DataRequirementAdapter
extends BaseAdapter
implements IDataRequirementAdapter {
    private final DataRequirement dataRequirement;

    public DataRequirementAdapter(IBase compositeType) {
        super(FhirVersionEnum.R5, compositeType);
        if (!(compositeType instanceof DataRequirement)) {
            throw new IllegalArgumentException("object passed as dataRequirement argument is not a DataRequirement data type");
        }
        DataRequirement dataRequirementInner = (DataRequirement)compositeType;
        this.dataRequirement = dataRequirementInner;
    }

    @Override
    public DataRequirement get() {
        return this.dataRequirement;
    }

    @Override
    public boolean hasId() {
        return this.get().hasId();
    }

    @Override
    public String getId() {
        return this.get().getId();
    }

    @Override
    public boolean hasType() {
        return this.get().hasType();
    }

    @Override
    public String getType() {
        return this.get().getType().toCode();
    }

    @Override
    public boolean hasCodeFilter() {
        return this.get().hasCodeFilter();
    }

    @Override
    public List<IDataRequirementCodeFilterAdapter> getCodeFilter() {
        return this.get().getCodeFilter().stream().map(DataRequirementCodeFilterAdapter::new).collect(Collectors.toUnmodifiableList());
    }
}

