/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.r5;

import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r5.model.DataRequirement;
import org.opencds.cqf.fhir.utility.adapter.BaseAdapter;
import org.opencds.cqf.fhir.utility.adapter.ICodingAdapter;
import org.opencds.cqf.fhir.utility.adapter.IDataRequirementCodeFilterAdapter;
import org.opencds.cqf.fhir.utility.adapter.r5.CodingAdapter;

public class DataRequirementCodeFilterAdapter
extends BaseAdapter
implements IDataRequirementCodeFilterAdapter {
    private final DataRequirement.DataRequirementCodeFilterComponent codeFilter;

    public DataRequirementCodeFilterAdapter(IBase codeFilter) {
        super(FhirVersionEnum.R5, codeFilter);
        if (!(codeFilter instanceof DataRequirement.DataRequirementCodeFilterComponent)) {
            throw new IllegalArgumentException("object passed as codeFilter argument is not a DataRequirementCodeFilterComponent data type");
        }
        this.codeFilter = (DataRequirement.DataRequirementCodeFilterComponent)codeFilter;
    }

    @Override
    public DataRequirement.DataRequirementCodeFilterComponent get() {
        return this.codeFilter;
    }

    @Override
    public boolean hasCode() {
        return this.get().hasCode();
    }

    @Override
    public List<ICodingAdapter> getCode() {
        return this.get().getCode().stream().map(CodingAdapter::new).collect(Collectors.toList());
    }

    @Override
    public boolean hasPath() {
        return this.get().hasPath();
    }

    @Override
    public String getPath() {
        return this.get().getPath();
    }

    @Override
    public boolean hasValueSet() {
        return this.get().hasValueSet();
    }

    @Override
    public IPrimitiveType<String> getValueSet() {
        return this.get().getValueSetElement();
    }
}

