/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.r5;

import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.opencds.cqf.fhir.utility.adapter.BaseAdapter;
import org.opencds.cqf.fhir.utility.adapter.IPlanDefinitionActionAdapter;
import org.opencds.cqf.fhir.utility.adapter.ITriggerDefinitionAdapter;
import org.opencds.cqf.fhir.utility.adapter.r5.TriggerDefinitionAdapter;

public class PlanDefinitionActionAdapter
extends BaseAdapter
implements IPlanDefinitionActionAdapter {
    private final PlanDefinition.PlanDefinitionActionComponent action;

    public PlanDefinitionActionAdapter(IBase action) {
        super(FhirVersionEnum.R5, action);
        if (!(action instanceof PlanDefinition.PlanDefinitionActionComponent)) {
            throw new IllegalArgumentException("object passed as action argument is not a PlanDefinitionActionComponent data type");
        }
        this.action = (PlanDefinition.PlanDefinitionActionComponent)action;
    }

    @Override
    public PlanDefinition.PlanDefinitionActionComponent get() {
        return this.action;
    }

    @Override
    public boolean hasTrigger() {
        return this.get().hasTrigger();
    }

    @Override
    public List<ITriggerDefinitionAdapter> getTrigger() {
        return this.get().getTrigger().stream().map(TriggerDefinitionAdapter::new).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public List<String> getTriggerType() {
        return this.get().getTrigger().stream().map(t -> t.getType().toCode()).toList();
    }
}

