/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.r5;

import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.opencds.cqf.fhir.utility.adapter.BaseAdapter;
import org.opencds.cqf.fhir.utility.adapter.IAdapter;
import org.opencds.cqf.fhir.utility.adapter.IItemComponentAdapter;
import org.opencds.cqf.fhir.utility.adapter.IQuestionnaireResponseItemAnswerComponentAdapter;
import org.opencds.cqf.fhir.utility.adapter.IQuestionnaireResponseItemComponentAdapter;

public class QuestionnaireResponseItemComponentAdapter
extends BaseAdapter
implements IQuestionnaireResponseItemComponentAdapter {
    private final QuestionnaireResponse.QuestionnaireResponseItemComponent item;

    public QuestionnaireResponseItemComponentAdapter(IBase item) {
        super(FhirVersionEnum.R5, item);
        if (!(item instanceof QuestionnaireResponse.QuestionnaireResponseItemComponent)) {
            throw new IllegalArgumentException("object passed as item argument is not a QuestionnaireResponseItemComponent data type");
        }
        this.item = (QuestionnaireResponse.QuestionnaireResponseItemComponent)item;
    }

    @Override
    public QuestionnaireResponse.QuestionnaireResponseItemComponent get() {
        return this.item;
    }

    @Override
    public String getLinkId() {
        return this.item.getLinkId();
    }

    @Override
    public IQuestionnaireResponseItemComponentAdapter setLinkId(String linkId) {
        this.get().setLinkId(linkId);
        return this;
    }

    @Override
    public IQuestionnaireResponseItemComponentAdapter setDefinition(String definition) {
        this.get().setDefinition(definition);
        return this;
    }

    @Override
    public boolean hasDefinition() {
        return this.item.hasDefinition();
    }

    @Override
    public String getDefinition() {
        return this.item.getDefinition();
    }

    @Override
    public boolean hasItem() {
        return this.item.hasItem();
    }

    public List<IQuestionnaireResponseItemComponentAdapter> getItem() {
        return this.item.getItem().stream().map(this.adapterFactory::createQuestionnaireResponseItem).toList();
    }

    @Override
    public void setItem(List<? extends IItemComponentAdapter> items) {
        this.item.setItem(items.stream().map(IAdapter::get).map(QuestionnaireResponse.QuestionnaireResponseItemComponent.class::cast).collect(Collectors.toList()));
    }

    @Override
    public void addItem(IItemComponentAdapter item) {
        this.item.addItem((QuestionnaireResponse.QuestionnaireResponseItemComponent)item.get());
    }

    @Override
    public void addItems(List<IQuestionnaireResponseItemComponentAdapter> items) {
        items.stream().map(IAdapter::get).map(QuestionnaireResponse.QuestionnaireResponseItemComponent.class::cast).forEach(arg_0 -> ((QuestionnaireResponse.QuestionnaireResponseItemComponent)this.item).addItem(arg_0));
    }

    @Override
    public boolean hasAnswer() {
        return this.item.hasAnswer();
    }

    @Override
    public List<IQuestionnaireResponseItemAnswerComponentAdapter> getAnswer() {
        return this.item.getAnswer().stream().map(this.adapterFactory::createQuestionnaireResponseItemAnswer).collect(Collectors.toList());
    }

    @Override
    public void setAnswer(List<IQuestionnaireResponseItemAnswerComponentAdapter> answers) {
        this.item.setAnswer(answers.stream().map(IAdapter::get).filter(QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent.class::isInstance).map(QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent.class::cast).toList());
    }

    @Override
    public IQuestionnaireResponseItemAnswerComponentAdapter newAnswer(IBaseDatatype value) {
        return this.adapterFactory.createQuestionnaireResponseItemAnswer((IBase)new QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent().setValue((DataType)value));
    }
}

