/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.r5;

import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.RequestOrchestration;
import org.opencds.cqf.fhir.utility.adapter.BaseAdapter;
import org.opencds.cqf.fhir.utility.adapter.ICodeableConceptAdapter;
import org.opencds.cqf.fhir.utility.adapter.IRequestActionAdapter;
import org.opencds.cqf.fhir.utility.adapter.r5.CodeableConceptAdapter;

public class RequestActionAdapter
extends BaseAdapter
implements IRequestActionAdapter {
    private final RequestOrchestration.RequestOrchestrationActionComponent action;

    public RequestActionAdapter(IBase action) {
        super(FhirVersionEnum.R5, action);
        if (!(action instanceof RequestOrchestration.RequestOrchestrationActionComponent)) {
            throw new IllegalArgumentException("element passed as action argument is not a RequestOrchestrationActionComponent Element");
        }
        this.action = (RequestOrchestration.RequestOrchestrationActionComponent)action;
    }

    @Override
    public RequestOrchestration.RequestOrchestrationActionComponent get() {
        return this.action;
    }

    @Override
    public String getId() {
        return this.get().getId();
    }

    @Override
    public boolean hasTitle() {
        return this.get().hasTitle();
    }

    @Override
    public String getTitle() {
        return this.get().getTitle();
    }

    @Override
    public boolean hasDescription() {
        return this.get().hasDescription();
    }

    @Override
    public String getDescription() {
        return this.get().getDescription();
    }

    @Override
    public boolean hasType() {
        return this.get().hasType();
    }

    @Override
    public ICodeableConceptAdapter getType() {
        return new CodeableConceptAdapter((IBase)this.get().getType());
    }

    @Override
    public boolean hasPriority() {
        return this.get().hasPriority();
    }

    @Override
    public String getPriority() {
        return this.get().getPriority().toCode();
    }

    @Override
    public boolean hasDocumentation() {
        return this.get().hasDocumentation();
    }

    public List<RelatedArtifact> getDocumentation() {
        return this.get().getDocumentation();
    }

    @Override
    public boolean hasSelectionBehavior() {
        return this.get().hasSelectionBehavior();
    }

    @Override
    public String getSelectionBehavior() {
        return this.get().getSelectionBehavior().toCode();
    }

    @Override
    public boolean hasResource() {
        return this.get().hasResource();
    }

    public Reference getResource() {
        return this.get().getResource();
    }

    @Override
    public boolean hasAction() {
        return this.get().hasAction();
    }

    @Override
    public List<IRequestActionAdapter> getAction() {
        return this.get().getAction().stream().map(RequestActionAdapter::new).collect(Collectors.toUnmodifiableList());
    }
}

