/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.r5;

import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.r5.model.ValueSet;
import org.opencds.cqf.fhir.utility.adapter.BaseAdapter;
import org.opencds.cqf.fhir.utility.adapter.IValueSetConceptReferenceAdapter;
import org.opencds.cqf.fhir.utility.adapter.IValueSetConceptSetAdapter;
import org.opencds.cqf.fhir.utility.adapter.r5.ValueSetConceptReferenceAdapter;

public class ValueSetConceptSetAdapter
extends BaseAdapter
implements IValueSetConceptSetAdapter {
    private final ValueSet.ConceptSetComponent conceptSet;

    public ValueSetConceptSetAdapter(IBase conceptSet) {
        super(FhirVersionEnum.R5, conceptSet);
        if (!(conceptSet instanceof ValueSet.ConceptSetComponent)) {
            throw new IllegalArgumentException("element passed as conceptSet argument is not a ConceptSetComponent element");
        }
        this.conceptSet = (ValueSet.ConceptSetComponent)conceptSet;
    }

    @Override
    public ValueSet.ConceptSetComponent get() {
        return this.conceptSet;
    }

    @Override
    public boolean hasConcept() {
        return this.get().hasConcept();
    }

    @Override
    public List<IValueSetConceptReferenceAdapter> getConcept() {
        return this.get().getConcept().stream().map(ValueSetConceptReferenceAdapter::new).collect(Collectors.toList());
    }

    @Override
    public boolean hasSystem() {
        return this.get().hasSystem();
    }

    @Override
    public String getSystem() {
        return this.get().getSystem();
    }
}

