/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.client;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.gclient.IQuery;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseEnumFactory;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.Enumerations;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.Parameters;
import org.opencds.cqf.fhir.utility.Resources;
import org.opencds.cqf.fhir.utility.adapter.IEndpointAdapter;
import org.opencds.cqf.fhir.utility.adapter.IKnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.adapter.IParametersAdapter;
import org.opencds.cqf.fhir.utility.adapter.IValueSetAdapter;
import org.opencds.cqf.fhir.utility.client.Clients;
import org.opencds.cqf.fhir.utility.client.ExpandRunner;
import org.opencds.cqf.fhir.utility.client.TerminologyServerClientSettings;
import org.opencds.cqf.fhir.utility.search.Searches;

public class TerminologyServerClient {
    private final FhirContext fhirContext;
    private final TerminologyServerClientSettings terminologyServerClientSettings;
    public static final String versionParamName = "valueSetVersion";
    public static final String urlParamName = "url";

    public TerminologyServerClient(FhirContext fhirContext) {
        this(fhirContext, null);
    }

    public TerminologyServerClient(FhirContext fhirContext, TerminologyServerClientSettings terminologyServerClientSettings) {
        this.fhirContext = Objects.requireNonNull(fhirContext);
        this.terminologyServerClientSettings = terminologyServerClientSettings != null ? terminologyServerClientSettings : TerminologyServerClientSettings.getDefault();
    }

    public TerminologyServerClientSettings getTerminologyServerClientSettings() {
        return this.terminologyServerClientSettings;
    }

    public TerminologyCapabilities getR4TerminologyCapabilities(IEndpointAdapter endpoint) {
        IGenericClient fhirClient = this.initializeClientWithAuth(endpoint);
        return (TerminologyCapabilities)fhirClient.fetchResourceFromUrl(TerminologyCapabilities.class, "/metadata?mode=terminology");
    }

    public IBaseResource expand(IValueSetAdapter valueSet, IEndpointAdapter endpoint, IParametersAdapter parameters) {
        Preconditions.checkNotNull((Object)valueSet, (Object)"expected non-null value for valueSet");
        Preconditions.checkNotNull((Object)endpoint, (Object)"expected non-null value for endpoint");
        Preconditions.checkNotNull((Object)parameters, (Object)"expected non-null value for parameters");
        return this.expand(endpoint, parameters, valueSet.getUrl(), valueSet.getVersion(), valueSet.get().getStructureFhirVersionEnum());
    }

    public IBaseResource expand(IEndpointAdapter endpoint, IParametersAdapter parameters, FhirVersionEnum fhirVersion) {
        Preconditions.checkNotNull((Object)endpoint, (Object)"expected non-null value for endpoint");
        Preconditions.checkNotNull((Object)parameters, (Object)"expected non-null value for parameters");
        Preconditions.checkNotNull((Object)fhirVersion, (Object)"expected non-null value for fhirVersion");
        Preconditions.checkNotNull((Object)parameters.getParameter(urlParamName), (Object)"expected non-null value for 'url' expansion parameter");
        return this.expand(endpoint, parameters, null, null, fhirVersion);
    }

    public IBaseResource expand(IEndpointAdapter endpoint, IParametersAdapter parameters, String url, String valueSetVersion, FhirVersionEnum fhirVersion) {
        Preconditions.checkNotNull((Object)endpoint, (Object)"expected non-null value for endpoint");
        Preconditions.checkNotNull((Object)parameters, (Object)"expected non-null value for parameters");
        IGenericClient fhirClient = this.initializeClientWithAuth(endpoint);
        if (parameters.getParameter(urlParamName) == null) {
            if (url == null) {
                throw new UnprocessableEntityException("No 'url' expansion parameter present");
            }
            parameters.addParameter(fhirVersion == FhirVersionEnum.DSTU3 ? Parameters.newUriPart(this.fhirContext, urlParamName, url, new IBase[0]) : Parameters.newUrlPart(this.fhirContext, urlParamName, url, new IBase[0]));
        }
        if (parameters.getParameter(versionParamName) == null && valueSetVersion != null) {
            parameters.addParameter(Parameters.newStringPart(this.fhirContext, versionParamName, valueSetVersion, new IBase[0]));
        }
        return this.expand(fhirClient, url, (IBaseParameters)parameters.get());
    }

    public IBaseResource expand(IGenericClient fhirClient, String url, IBaseParameters parameters) {
        ExpandRunner expandRunner = new ExpandRunner(fhirClient, this.terminologyServerClientSettings, url, parameters);
        return expandRunner.expandValueSet();
    }

    public IGenericClient initializeClientWithAuth(IEndpointAdapter endpoint) {
        String username = endpoint.getExtensionsByUrl("vsacUsername").stream().findFirst().map(ext -> ext.getValue().toString()).orElseThrow(() -> new UnprocessableEntityException("Cannot expand ValueSet without VSAC Username."));
        String apiKey = endpoint.getExtensionsByUrl("apiKey").stream().findFirst().map(ext -> ext.getValue().toString()).orElseThrow(() -> new UnprocessableEntityException("Cannot expand ValueSet without VSAC API Key."));
        IGenericClient fhirClient = this.fhirContext.newRestfulGenericClient(this.getAddressBase(endpoint.getAddress()));
        fhirClient.getFhirContext().getRestfulClientFactory().setSocketTimeout(this.terminologyServerClientSettings.getSocketTimeout() * 1000);
        Clients.registerAdditionalRequestHeadersAuth(fhirClient, username, apiKey);
        return fhirClient;
    }

    public Optional<IDomainResource> getValueSetResource(IEndpointAdapter endpoint, String url) {
        return IKnowledgeArtifactAdapter.findLatestVersion((IBaseBundle)((IQuery)this.initializeClientWithAuth(endpoint).search().forResource(this.getValueSetClass()).where(Searches.byCanonical(url))).execute());
    }

    public Optional<IDomainResource> getCodeSystemResource(IEndpointAdapter endpoint, String url) {
        return IKnowledgeArtifactAdapter.findLatestVersion((IBaseBundle)((IQuery)this.initializeClientWithAuth(endpoint).search().forResource(this.getCodeSystemClass()).where(Searches.byCanonical(url))).execute());
    }

    public Optional<IDomainResource> getLatestNonDraftValueSetResource(IEndpointAdapter endpoint, String url) {
        Map<String, List<IQueryParameterType>> urlParams = Searches.byCanonical(url);
        Map<String, List<IQueryParameterType>> statusParam = Searches.exceptStatus("draft");
        urlParams.putAll(statusParam);
        return IKnowledgeArtifactAdapter.findLatestVersion((IBaseBundle)((IQuery)this.initializeClientWithAuth(endpoint).search().forResource(this.getValueSetClass()).where(urlParams)).execute());
    }

    public Class<? extends IBaseResource> getValueSetClass() {
        return Resources.getClassForTypeAndVersion("ValueSet", this.fhirContext.getVersion().getVersion());
    }

    public Class<? extends IBaseResource> getCodeSystemClass() {
        return Resources.getClassForTypeAndVersion("CodeSystem", this.fhirContext.getVersion().getVersion());
    }

    private String getAddressBase(String address) {
        return TerminologyServerClient.getAddressBase(address, this.fhirContext);
    }

    public static String getAddressBase(String address, FhirContext ctx) {
        String maybeFhirType;
        Objects.requireNonNull(address, "address must not be null");
        if (address.startsWith("http://")) {
            address = address.replaceFirst("http://", "https://");
        }
        if (address.endsWith("/")) {
            address = address.substring(0, address.length() - 1);
        }
        if ((maybeFhirType = Canonicals.getResourceType(address)) != null && StringUtils.isNotBlank((CharSequence)maybeFhirType)) {
            IBaseEnumFactory<?> factory = TerminologyServerClient.getEnumFactory(ctx);
            try {
                factory.fromCode(maybeFhirType);
            }
            catch (IllegalArgumentException e) {
                int lastSlashIndex = address.lastIndexOf("/");
                if (lastSlashIndex > 0) {
                    maybeFhirType = address.substring(lastSlashIndex + 1, address.length());
                    try {
                        factory.fromCode(maybeFhirType);
                    }
                    catch (IllegalArgumentException e2) {
                        return address;
                    }
                }
                return address;
            }
            address = address.substring(0, address.indexOf(maybeFhirType) - 1);
        }
        return address;
    }

    public static IBaseEnumFactory<?> getEnumFactory(FhirContext ctx) {
        switch (ctx.getVersion().getVersion()) {
            case DSTU3: {
                return new Enumerations.ResourceTypeEnumFactory();
            }
            case R4: {
                return new Enumerations.ResourceTypeEnumFactory();
            }
            case R5: {
                return new Enumerations.ResourceTypeEnumEnumFactory();
            }
        }
        throw new UnprocessableEntityException("unsupported FHIR version: " + ctx.getVersion().getVersion().toString());
    }
}

