/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.dstu3;

import ca.uhn.fhir.repository.IRepository;
import java.util.List;
import java.util.function.Consumer;
import org.hl7.fhir.dstu3.model.ActivityDefinition;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.Library;
import org.hl7.fhir.dstu3.model.Measure;
import org.hl7.fhir.dstu3.model.MetadataResource;
import org.hl7.fhir.dstu3.model.PlanDefinition;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.instance.model.api.IIdType;

public class MetadataResourceHelper {
    public static void forEachMetadataResource(List<Bundle.BundleEntryComponent> entries, Consumer<MetadataResource> callback, IRepository repository) {
        entries.stream().map(entry -> entry.getResponse().getLocation()).map(location -> {
            switch (location.split("/")[0]) {
                case "ActivityDefinition": {
                    return (MetadataResource)repository.read(ActivityDefinition.class, (IIdType)new IdType(location));
                }
                case "Library": {
                    return (MetadataResource)repository.read(Library.class, (IIdType)new IdType(location));
                }
                case "Measure": {
                    return (MetadataResource)repository.read(Measure.class, (IIdType)new IdType(location));
                }
                case "PlanDefinition": {
                    return (MetadataResource)repository.read(PlanDefinition.class, (IIdType)new IdType(location));
                }
                case "ValueSet": {
                    return (MetadataResource)repository.read(ValueSet.class, (IIdType)new IdType(location));
                }
            }
            return null;
        }).forEach(callback);
    }
}

