/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.iterable;

import ca.uhn.fhir.repository.IRepository;
import ca.uhn.fhir.util.bundle.BundleEntryParts;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.opencds.cqf.fhir.utility.iterable.BundleIterator;

public class BundleMappingIterator<B extends IBaseBundle, T>
implements Iterator<T> {
    private final Function<BundleEntryParts, T> mapper;
    private final BundleIterator<B> inner;

    public BundleMappingIterator(IRepository repository, B bundle, Function<BundleEntryParts, T> mapper) {
        this.inner = new BundleIterator<B>(repository, bundle);
        this.mapper = mapper;
    }

    @Override
    public boolean hasNext() {
        return this.inner.hasNext();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        BundleEntryParts next = this.inner.next();
        return this.mapper.apply(next);
    }
}

