/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.matcher;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.TokenParamModifier;
import ca.uhn.fhir.rest.param.UriParam;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseEnumeration;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public interface ResourceMatcher {
    public IFhirPath getEngine();

    public FhirContext getContext();

    public Map<SPPathKey, IFhirPath.IParsedExpression> getPathCache();

    public void addCustomParameter(RuntimeSearchParam var1);

    public Map<String, RuntimeSearchParam> getCustomParameters();

    default public boolean matches(String name, List<IQueryParameterType> params, IBaseResource resource) {
        boolean match = true;
        FhirContext context = this.getContext();
        RuntimeSearchParam s = context.getResourceDefinition(resource).getSearchParam(name);
        if (s == null) {
            s = this.getCustomParameters().get(name);
        }
        if (s == null) {
            throw new RuntimeException("The SearchParameter %s for Resource %s is not supported.".formatted(name, resource.fhirType()));
        }
        String path = s.getPath();
        if (path.isEmpty() && name.startsWith("_")) {
            path = name.substring(1);
        }
        List pathResult = null;
        try {
            IFhirPath.IParsedExpression parsed = this.getPathCache().computeIfAbsent(new SPPathKey(resource.fhirType(), path), p -> {
                try {
                    return this.getEngine().parse(p.path());
                }
                catch (Exception e) {
                    throw new RuntimeException("Parsing SearchParameter %s for Resource %s resulted in an error.".formatted(name, resource.fhirType()), e);
                }
            });
            pathResult = this.getEngine().evaluate((IBase)resource, parsed, IBase.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Evaluating SearchParameter %s for Resource %s resulted in an error.".formatted(name, resource.fhirType()), e);
        }
        if (pathResult == null || pathResult.isEmpty()) {
            return false;
        }
        for (IQueryParameterType param : params) {
            for (IBase r : pathResult) {
                if (param instanceof ReferenceParam) {
                    match = this.isMatchReference(param, r);
                } else if (param instanceof DateParam) {
                    DateParam date = (DateParam)param;
                    match = this.isMatchDate(date, r);
                } else if (param instanceof TokenParam) {
                    TokenParam token = (TokenParam)param;
                    match = ResourceMatcher.applyModifiers(this.isMatchToken(token, r), token);
                    if (!match) {
                        List<TokenParam> codes = this.getCodes(r);
                        match = this.isMatchCoding(token, r, codes);
                    }
                } else if (param instanceof UriParam) {
                    UriParam uri = (UriParam)param;
                    match = this.isMatchUri(uri, r);
                } else if (param instanceof StringParam) {
                    StringParam string = (StringParam)param;
                    match = this.isMatchString(string, r);
                } else {
                    throw new NotImplementedException("Resource matching not implemented for search params of type " + param.getClass().getSimpleName());
                }
                if (!match) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean applyModifiers(boolean input, TokenParam token) {
        if (token.getModifier() != null && token.getModifier() != TokenParamModifier.NOT) {
            throw new NotImplementedException("Only the NOT modifier is supported on tokens at this time");
        }
        if (token.getModifier() == TokenParamModifier.NOT) {
            return !input;
        }
        return input;
    }

    default public boolean isMatchReference(IQueryParameterType param, IBase pathResult) {
        if (pathResult instanceof IBaseReference) {
            IBaseReference reference1 = (IBaseReference)pathResult;
            return reference1.getReferenceElement().getValue().equals(((ReferenceParam)param).getValue());
        }
        if (pathResult instanceof IPrimitiveType) {
            IPrimitiveType type1 = (IPrimitiveType)pathResult;
            return type1.getValueAsString().equals(((ReferenceParam)param).getValue());
        }
        if (pathResult instanceof Iterable) {
            Iterable iterable = (Iterable)pathResult;
            for (Object element : iterable) {
                IPrimitiveType type;
                IBaseReference reference;
                if (element instanceof IBaseReference && (reference = (IBaseReference)element).getReferenceElement().getValue().equals(((ReferenceParam)param).getValue())) {
                    return true;
                }
                if (!(element instanceof IPrimitiveType) || !(type = (IPrimitiveType)element).getValueAsString().equals(((ReferenceParam)param).getValue())) continue;
                return true;
            }
        } else {
            throw new UnsupportedOperationException("Expected Reference element, found " + pathResult.getClass().getSimpleName());
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isMatchDate(DateParam param, IBase pathResult) {
        DateRangeParam dateRange;
        if (pathResult instanceof IPrimitiveType) {
            IPrimitiveType type1 = (IPrimitiveType)pathResult;
            Object result = type1.getValue();
            if (!(result instanceof Date)) throw new UnsupportedOperationException("Expected date, found " + pathResult.getClass().getSimpleName());
            Date date = (Date)result;
            dateRange = new DateRangeParam(date, date);
            return this.matchesDateBounds(dateRange, new DateRangeParam(param));
        } else {
            if (!(pathResult instanceof ICompositeType)) throw new UnsupportedOperationException("Expected element of type date, dateTime, instant, Timing or Period, found " + pathResult.getClass().getSimpleName());
            ICompositeType type = (ICompositeType)pathResult;
            dateRange = this.getDateRange(type);
        }
        return this.matchesDateBounds(dateRange, new DateRangeParam(param));
    }

    default public boolean isMatchToken(TokenParam param, IBase pathResult) {
        if (param.getValue() == null) {
            return true;
        }
        if (pathResult instanceof IIdType) {
            IIdType id = (IIdType)pathResult;
            return param.getValue().equals(id.getIdPart());
        }
        if (pathResult instanceof IBaseEnumeration) {
            IBaseEnumeration enumeration = (IBaseEnumeration)pathResult;
            return param.getValue().equals(enumeration.getValueAsString());
        }
        if (pathResult instanceof IPrimitiveType) {
            IPrimitiveType type = (IPrimitiveType)pathResult;
            return param.getValue().equals(type.getValue());
        }
        return false;
    }

    default public boolean isMatchCoding(TokenParam param, IBase pathResult, List<TokenParam> codes) {
        if (codes == null || codes.isEmpty()) {
            return false;
        }
        if (param.getModifier() == TokenParamModifier.IN) {
            throw new UnsupportedOperationException("In modifier is unsupported");
        }
        for (TokenParam c : codes) {
            boolean matches = param.getValue().equals(c.getValue()) && (param.getSystem() == null || param.getSystem().equals(c.getSystem()));
            if (!matches) continue;
            return true;
        }
        return false;
    }

    default public boolean isMatchUri(UriParam param, IBase pathResult) {
        if (pathResult instanceof IPrimitiveType) {
            IPrimitiveType type = (IPrimitiveType)pathResult;
            return param.getValue().equals(type.getValue());
        }
        throw new UnsupportedOperationException("Expected element of type url or uri, found " + pathResult.getClass().getSimpleName());
    }

    default public boolean isMatchString(StringParam param, Object pathResult) {
        if (pathResult instanceof IPrimitiveType) {
            IPrimitiveType type = (IPrimitiveType)pathResult;
            return param.getValue().equals(type.getValue());
        }
        throw new UnsupportedOperationException("Expected element of type string, found " + pathResult.getClass().getSimpleName());
    }

    default public boolean matchesDateBounds(DateRangeParam resourceRange, DateRangeParam paramRange) {
        Date resourceLowerBound = resourceRange.getLowerBoundAsInstant();
        Date resourceUpperBound = resourceRange.getUpperBoundAsInstant();
        Date paramLowerBound = paramRange.getLowerBoundAsInstant();
        Date paramUpperBound = paramRange.getUpperBoundAsInstant();
        if (paramLowerBound == null && paramUpperBound == null) {
            return false;
        }
        boolean result = true;
        if (paramLowerBound != null) {
            result &= resourceLowerBound.after(paramLowerBound) || resourceLowerBound.equals(paramLowerBound);
            result &= resourceUpperBound.after(paramLowerBound) || resourceUpperBound.equals(paramLowerBound);
        }
        if (paramUpperBound != null) {
            result &= resourceLowerBound.before(paramUpperBound) || resourceLowerBound.equals(paramUpperBound);
            result &= resourceUpperBound.before(paramUpperBound) || resourceUpperBound.equals(paramUpperBound);
        }
        return result;
    }

    public DateRangeParam getDateRange(ICompositeType var1);

    public List<TokenParam> getCodes(IBase var1);

    public static class SPPathKey {
        private final String resourceType;
        private final String resourcePath;

        public SPPathKey(String resourceType, String resourcePath) {
            this.resourceType = resourceType;
            this.resourcePath = resourcePath;
        }

        public String path() {
            return this.resourcePath;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.resourceType == null ? 0 : this.resourceType.hashCode());
            result = 31 * result + (this.resourcePath == null ? 0 : this.resourcePath.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SPPathKey or = (SPPathKey)obj;
            if (this.resourceType == null ? or.resourceType != null : !this.resourceType.equals(or.resourceType)) {
                return false;
            }
            return !(this.resourcePath == null ? or.resourcePath != null : !this.resourcePath.equals(or.resourcePath));
        }
    }
}

