/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.r5;

import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.repository.IRepository;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.Resource;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.search.Searches;

public class SearchHelper {
    private SearchHelper() {
    }

    public static <CanonicalType extends IPrimitiveType<String>> Resource searchRepositoryByCanonical(IRepository repository, CanonicalType canonical) {
        Map<String, List<IQueryParameterType>> searchParams;
        String url = Canonicals.getUrl(canonical);
        String version = Canonicals.getVersion(canonical);
        Class resourceType = repository.fhirContext().getResourceDefinition(Canonicals.getResourceType(canonical)).getImplementingClass();
        Bundle searchResult = (Bundle)repository.search(Bundle.class, resourceType, searchParams = version == null ? Searches.byUrl(url) : Searches.byUrlAndVersion(url, version));
        if (!searchResult.hasEntry()) {
            throw new FHIRException("No resource of type %s found for url: %s|%s".formatted(resourceType.getSimpleName(), url, version));
        }
        return searchResult.getEntryFirstRep().getResource();
    }

    public static <T extends IBaseResource> Bundle searchRepositoryWithPaging(IRepository repository, Class<T> resourceType, Map<String, List<IQueryParameterType>> searchParameters, Map<String, String> headers) {
        Bundle result = (Bundle)repository.search(Bundle.class, resourceType, searchParameters, headers);
        Bundle.BundleLinkComponent next = result.getLink("next");
        if (next != null) {
            SearchHelper.getNextPage(repository, result, next.getUrl());
        }
        return result;
    }

    private static void getNextPage(IRepository repository, Bundle bundle, String nextUrl) {
        Bundle nextBundle = (Bundle)repository.link(Bundle.class, nextUrl);
        nextBundle.getEntry().forEach(arg_0 -> ((Bundle)bundle).addEntry(arg_0));
        Bundle.BundleLinkComponent next = nextBundle.getLink("next");
        if (next != null) {
            SearchHelper.getNextPage(repository, bundle, next.getUrl());
        }
    }
}

