/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.repository;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.repository.IRepository;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.NotImplementedOperationException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.util.BundleBuilder;
import ca.uhn.fhir.util.BundleUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseConformance;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.Ids;
import org.opencds.cqf.fhir.utility.matcher.ResourceMatcher;
import org.opencds.cqf.fhir.utility.operation.OperationRegistry;
import org.opencds.cqf.fhir.utility.repository.Repositories;

public class InMemoryFhirRepository
implements IRepository {
    private final Map<String, Map<IIdType, IBaseResource>> resourceMap;
    private final FhirContext context;
    private final OperationRegistry operationRegistry;
    private final ResourceMatcher resourceMatcher;

    public InMemoryFhirRepository(FhirContext context) {
        this.context = context;
        this.resourceMap = new HashMap<String, Map<IIdType, IBaseResource>>();
        this.operationRegistry = new OperationRegistry();
        this.resourceMatcher = Repositories.getResourceMatcher(this.context);
    }

    public InMemoryFhirRepository(FhirContext context, IBaseBundle bundle) {
        this.context = context;
        List resources = BundleUtil.toListOfResources((FhirContext)this.context, (IBaseBundle)bundle);
        this.resourceMap = resources.stream().collect(Collectors.groupingBy(IBase::fhirType, Collectors.toMap(r -> r.getIdElement().toUnqualifiedVersionless(), Function.identity())));
        this.operationRegistry = new OperationRegistry();
        this.resourceMatcher = Repositories.getResourceMatcher(this.context);
    }

    public <T extends IBaseResource, I extends IIdType> T read(Class<T> resourceType, I id, Map<String, String> headers) {
        Map resources = this.resourceMap.computeIfAbsent(resourceType.getSimpleName(), x -> new HashMap());
        IBaseResource resource = (IBaseResource)resources.get(id.toUnqualifiedVersionless());
        if (resource == null) {
            throw new ResourceNotFoundException(id);
        }
        return (T)resource;
    }

    public <T extends IBaseResource> MethodOutcome create(T resource, Map<String, String> headers) {
        Map resources = this.resourceMap.computeIfAbsent(resource.fhirType(), r -> new HashMap());
        Object theId = Ids.newRandomId(this.context, resource.fhirType());
        while (resources.containsKey(theId)) {
            theId = Ids.newRandomId(this.context, resource.fhirType());
        }
        resource.setId(theId);
        MethodOutcome outcome = new MethodOutcome(theId, Boolean.valueOf(true));
        resources.put(theId.toUnqualifiedVersionless(), resource);
        return outcome;
    }

    public <I extends IIdType, P extends IBaseParameters> MethodOutcome patch(I id, P patchParameters, Map<String, String> headers) {
        throw new NotImplementedOperationException("The PATCH operation is not currently supported");
    }

    public <T extends IBaseResource> MethodOutcome update(T resource, Map<String, String> headers) {
        Map resources = this.resourceMap.computeIfAbsent(resource.fhirType(), r -> new HashMap());
        IIdType theId = resource.getIdElement().toUnqualifiedVersionless();
        MethodOutcome outcome = new MethodOutcome(theId, Boolean.valueOf(false));
        if (!resources.containsKey(theId)) {
            outcome.setCreated(Boolean.valueOf(true));
        }
        if (resource.fhirType().equals("SearchParameter")) {
            this.resourceMatcher.addCustomParameter(BundleHelper.resourceToRuntimeSearchParam(resource));
        }
        resources.put(theId, resource);
        return outcome;
    }

    public <T extends IBaseResource, I extends IIdType> MethodOutcome delete(Class<T> resourceType, I id, Map<String, String> headers) {
        IIdType keyId;
        MethodOutcome outcome = new MethodOutcome(id, Boolean.valueOf(false));
        Map resources = this.resourceMap.computeIfAbsent(id.getResourceType(), r -> new HashMap());
        if (!resources.containsKey(keyId = id.toUnqualifiedVersionless())) {
            throw new ResourceNotFoundException("Resource not found with id " + String.valueOf(id));
        }
        outcome.setResource((IBaseResource)resources.get(keyId));
        resources.remove(keyId);
        return outcome;
    }

    public <B extends IBaseBundle, T extends IBaseResource> B search(Class<B> bundleType, Class<T> resourceType, Multimap<String, List<IQueryParameterType>> searchParameters, Map<String, String> headers) {
        Collection candidates;
        Map resourceIdMap;
        BundleBuilder builder;
        block11: {
            block10: {
                builder = new BundleBuilder(this.context);
                resourceIdMap = this.resourceMap.computeIfAbsent(resourceType.getSimpleName(), r -> new HashMap());
                if (searchParameters == null) break block10;
                if (!searchParameters.isEmpty()) break block11;
            }
            resourceIdMap.values().forEach(arg_0 -> ((BundleBuilder)builder).addCollectionEntry(arg_0));
            builder.setType("searchset");
            return (B)builder.getBundle();
        }
        if (searchParameters.containsKey((Object)"_id")) {
            Collection idQueries = searchParameters.get((Object)"_id");
            ArrayList idResources = new ArrayList(idQueries.size());
            for (List idQuery : idQueries) {
                assert (idQuery != null);
                for (IQueryParameterType query : idQuery) {
                    if (!(query instanceof TokenParam)) continue;
                    TokenParam idToken = (TokenParam)query;
                    Object id = Ids.newId(this.context, resourceType.getSimpleName(), idToken.getValue());
                    IBaseResource r2 = (IBaseResource)resourceIdMap.get(id);
                    if (r2 == null) continue;
                    idResources.add(r2);
                }
            }
            candidates = idResources;
            searchParameters.removeAll((Object)"_id");
        } else {
            candidates = resourceIdMap.values();
        }
        for (IBaseResource resource : candidates) {
            boolean include = true;
            for (Map.Entry nextEntry : searchParameters.entries()) {
                String paramName = (String)nextEntry.getKey();
                if (this.resourceMatcher.matches(paramName, (List)nextEntry.getValue(), resource)) continue;
                include = false;
                break;
            }
            if (!include) continue;
            builder.addCollectionEntry(resource);
        }
        builder.setType("searchset");
        return (B)builder.getBundle();
    }

    public <B extends IBaseBundle> B link(Class<B> bundleType, String url, Map<String, String> headers) {
        throw new NotImplementedOperationException("Paging is not currently supported");
    }

    public <C extends IBaseConformance> C capabilities(Class<C> resourceType, Map<String, String> headers) {
        throw new NotImplementedOperationException("The capabilities interaction is not currently supported");
    }

    public <B extends IBaseBundle> B transaction(B transaction, Map<String, String> headers) {
        FhirVersionEnum version = transaction.getStructureFhirVersionEnum();
        IBaseBundle returnBundle = BundleHelper.newBundle(version);
        BundleHelper.getEntry(transaction).forEach(e -> {
            if (BundleHelper.isEntryRequestPut(version, e)) {
                MethodOutcome outcome = this.update(BundleHelper.getEntryResource(version, e));
                String location = outcome.getId().getValue();
                BundleHelper.addEntry(returnBundle, BundleHelper.newEntryWithResponse(version, BundleHelper.newResponseWithLocation(version, location)));
                return;
            } else if (BundleHelper.isEntryRequestPost(version, e)) {
                MethodOutcome outcome = this.create(BundleHelper.getEntryResource(version, e));
                String location = outcome.getId().getValue();
                BundleHelper.addEntry(returnBundle, BundleHelper.newEntryWithResponse(version, BundleHelper.newResponseWithLocation(version, location)));
                return;
            } else {
                if (!BundleHelper.isEntryRequestDelete(version, e)) throw new NotImplementedOperationException("Transaction stub only supports PUT, POST or DELETE");
                if (!BundleHelper.getEntryRequestId(version, e).isPresent()) throw new ResourceNotFoundException("Trying to delete an entry without id");
                String resourceType = Canonicals.getResourceType(BundleHelper.getEntryRequestUrl(version, e));
                Class resourceClass = this.context.getResourceDefinition(resourceType).getImplementingClass();
                MethodOutcome res = this.delete(resourceClass, BundleHelper.getEntryRequestId(version, e).get().withResourceType(resourceType));
                BundleHelper.addEntry(returnBundle, BundleHelper.newEntryWithResource(res.getResource()));
            }
        });
        return (B)returnBundle;
    }

    public <R extends IBaseResource, P extends IBaseParameters> R invoke(String name, P parameters, Class<R> returnType, Map<String, String> headers) {
        Preconditions.checkNotNull((Object)name, (Object)"name is required");
        Preconditions.checkNotNull(returnType, (Object)"returnType is required");
        Preconditions.checkNotNull(headers, (Object)"headers are required");
        try {
            IBaseResource result = this.operationRegistry.buildInvocationContext(this, name).parameters(parameters).execute();
            return (R)((IBaseResource)returnType.cast(result));
        }
        catch (BaseServerResponseException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InternalErrorException(e);
        }
    }

    public <P extends IBaseParameters> MethodOutcome invoke(String name, P parameters, Map<String, String> headers) {
        throw new NotImplementedOperationException("Invoke is not currently supported");
    }

    public <R extends IBaseResource, P extends IBaseParameters, T extends IBaseResource> R invoke(Class<T> resourceType, String name, P parameters, Class<R> returnType, Map<String, String> headers) {
        Preconditions.checkNotNull(resourceType, (Object)"resourceType is required");
        Preconditions.checkNotNull((Object)name, (Object)"name is required");
        Preconditions.checkNotNull(returnType, (Object)"returnType is required");
        Preconditions.checkNotNull(headers, (Object)"headers are required");
        try {
            IBaseResource result = this.operationRegistry.buildInvocationContext(this, name).parameters(parameters).resourceType(resourceType).execute();
            return (R)((IBaseResource)returnType.cast(result));
        }
        catch (BaseServerResponseException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InternalErrorException(e);
        }
    }

    public <P extends IBaseParameters, T extends IBaseResource> MethodOutcome invoke(Class<T> resourceType, String name, P parameters, Map<String, String> headers) {
        throw new NotImplementedOperationException("Invoke is not currently supported");
    }

    public <R extends IBaseResource, P extends IBaseParameters, I extends IIdType> R invoke(I id, String name, P parameters, Class<R> returnType, Map<String, String> headers) {
        Preconditions.checkNotNull(id, (Object)"id is required");
        Preconditions.checkArgument((boolean)id.hasResourceType(), (Object)"resourceType is required for id scoped operations");
        Preconditions.checkNotNull((Object)name, (Object)"name is required");
        Preconditions.checkNotNull(returnType, (Object)"returnType is required");
        Preconditions.checkNotNull(headers, (Object)"headers are required");
        try {
            IBaseResource result = this.operationRegistry.buildInvocationContext(this, name).parameters(parameters).id(id).resourceType(this.context.getResourceDefinition(id.getResourceType()).getImplementingClass()).execute();
            return (R)((IBaseResource)returnType.cast(result));
        }
        catch (BaseServerResponseException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InternalErrorException(e);
        }
    }

    public <P extends IBaseParameters, I extends IIdType> MethodOutcome invoke(I id, String name, P parameters, Map<String, String> headers) {
        throw new NotImplementedOperationException("Invoke is not currently supported");
    }

    public <B extends IBaseBundle, P extends IBaseParameters> B history(P parameters, Class<B> returnType, Map<String, String> headers) {
        throw new NotImplementedOperationException("The history interaction is not currently supported");
    }

    public <B extends IBaseBundle, P extends IBaseParameters, T extends IBaseResource> B history(Class<T> resourceType, P parameters, Class<B> returnType, Map<String, String> headers) {
        throw new NotImplementedOperationException("The history interaction is not currently supported");
    }

    public <B extends IBaseBundle, P extends IBaseParameters, I extends IIdType> B history(I id, P parameters, Class<B> returnType, Map<String, String> headers) {
        throw new NotImplementedOperationException("The history interaction is not currently supported");
    }

    @Nonnull
    public FhirContext fhirContext() {
        return this.context;
    }

    public <T> void registerOperation(Class<T> clazz, Function<IRepository, T> factory) {
        Objects.requireNonNull(clazz, "clazz can not be null");
        Objects.requireNonNull(factory, "factory can not be null");
        this.operationRegistry.register(clazz, factory);
    }
}

