/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.repository;

import ca.uhn.fhir.context.FhirContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;

public interface ResourceLoader {
    public Class<?> getRelativeClass();

    default public IBaseBundle loadBundle(FhirContext context, String location) {
        return (IBaseBundle)this.readResource(context, location);
    }

    default public IBaseResource readResource(FhirContext context, String location) {
        String resourceString = this.stringFromResource(location);
        if (location.endsWith("json")) {
            return this.parseResource(context, "json", resourceString);
        }
        return this.parseResource(context, "xml", resourceString);
    }

    default public IBaseResource parseResource(FhirContext context, String encoding, String resourceString) {
        return (switch (encoding.toLowerCase()) {
            case "json" -> context.newJsonParser();
            case "xml" -> context.newXmlParser();
            default -> throw new IllegalArgumentException("Expected encoding xml, or json.  %s is not a valid encoding".formatted(encoding));
        }).parseResource(resourceString);
    }

    default public IBaseResource loadResource(FhirContext context, String location) {
        String resourceString = this.stringFromResource(location);
        if (location.endsWith("json")) {
            return this.loadResource(context, "json", resourceString);
        }
        return this.loadResource(context, "xml", resourceString);
    }

    default public IBaseResource loadResource(FhirContext context, String encoding, String resourceString) {
        return this.parseResource(context, encoding, resourceString);
    }

    default public String stringFromResource(String location) {
        InputStream is = null;
        try {
            File f = new File(location);
            is = f.isFile() ? new FileInputStream(location) : this.getRelativeClass().getResourceAsStream(location);
            return IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading resource from %s".formatted(location), e);
        }
    }
}

