/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.repository.ig;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Enumerations;
import org.opencds.cqf.fhir.utility.repository.ig.EncodingBehavior;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record IgConventions(FhirTypeLayout typeLayout, CategoryLayout categoryLayout, CompartmentLayout compartmentLayout, FilenameMode filenameMode, EncodingBehavior encodingBehavior) {
    private static final Logger logger = LoggerFactory.getLogger(IgConventions.class);
    public static final IgConventions FLAT = new IgConventions(FhirTypeLayout.FLAT, CategoryLayout.FLAT, CompartmentLayout.FLAT, FilenameMode.TYPE_AND_ID, EncodingBehavior.DEFAULT);
    public static final IgConventions STANDARD = new IgConventions(FhirTypeLayout.DIRECTORY_PER_TYPE, CategoryLayout.DIRECTORY_PER_CATEGORY, CompartmentLayout.FLAT, FilenameMode.ID_ONLY, EncodingBehavior.DEFAULT);
    public static final IgConventions KALM = new IgConventions(FhirTypeLayout.DIRECTORY_PER_TYPE, CategoryLayout.DEFINITIONAL_AND_DATA, CompartmentLayout.DIRECTORY_PER_COMPARTMENT, FilenameMode.ID_ONLY, EncodingBehavior.KALM);
    private static final List<String> FHIR_TYPE_NAMES = Stream.of(Enumerations.FHIRAllTypes.values()).map(Enum::name).map(String::toLowerCase).distinct().toList();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IgConventions autoDetect(Path path) {
        Path typePath;
        Path tests;
        Path srcPath;
        if (path == null) return KALM;
        if (!Files.exists(path, new LinkOption[0])) {
            return KALM;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (Stream<Path> stream = Files.list(path);){
                if (!stream.findFirst().isPresent()) {
                    IgConventions igConventions = KALM;
                    return igConventions;
                }
            }
            catch (IOException e) {
                logger.warn("Error listing files in path: {}", (Object)path, (Object)e);
            }
        }
        if (Files.exists(srcPath = path.resolve("src"), new LinkOption[0])) {
            return KALM;
        }
        if (!Files.exists(path = path.resolve("input"), new LinkOption[0])) {
            throw new IllegalArgumentException("The provided path does not contain an 'input' or 'src' directory: " + String.valueOf(path));
        }
        Path categoryPath = Stream.of("tests", "vocabulary", "resources").map(path::resolve).filter(x -> x.toFile().exists()).findFirst().orElse(path);
        boolean hasCategoryDirectory = !path.equals(categoryPath);
        boolean hasCompartmentDirectory = false;
        if (hasCategoryDirectory && (tests = path.resolve("tests")).toFile().exists()) {
            Stream<Path> potentialCompartments = FHIR_TYPE_NAMES.stream().map(tests::resolve).filter(x -> x.toFile().exists());
            Path compartment = potentialCompartments.flatMap(IgConventions::listFiles).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(f -> !IgConventions.matchesAnyResourceType(f)).findFirst().orElse(categoryPath);
            boolean bl = hasCompartmentDirectory = !compartment.equals(categoryPath);
            if (hasCompartmentDirectory) {
                categoryPath = compartment;
            }
        }
        boolean hasTypeDirectory = !categoryPath.equals(typePath = FHIR_TYPE_NAMES.stream().map(categoryPath::resolve).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).findFirst().orElse(categoryPath));
        boolean hasTypeFilename = IgConventions.hasTypeFilename(typePath);
        IgConventions config = new IgConventions(hasTypeDirectory ? FhirTypeLayout.DIRECTORY_PER_TYPE : FhirTypeLayout.FLAT, hasCategoryDirectory ? CategoryLayout.DIRECTORY_PER_CATEGORY : CategoryLayout.FLAT, hasCompartmentDirectory ? CompartmentLayout.DIRECTORY_PER_COMPARTMENT : CompartmentLayout.FLAT, hasTypeFilename ? FilenameMode.TYPE_AND_ID : FilenameMode.ID_ONLY, EncodingBehavior.DEFAULT);
        logger.info("Auto-detected repository configuration: {}", (Object)config);
        return config;
    }

    private static boolean hasTypeFilename(Path typePath) {
        boolean bl;
        block8: {
            Stream<Path> fileStream = Files.list(typePath);
            try {
                bl = fileStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(IgConventions::fileNameMatchesType).filter(filePath -> IgConventions.claimedFhirType(filePath) != Enumerations.FHIRAllTypes.NULL).anyMatch(filePath -> IgConventions.contentsMatchClaimedType(filePath, IgConventions.claimedFhirType(filePath)));
                if (fileStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fileStream != null) {
                        try {
                            fileStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    logger.error("Error listing files in path: {}", (Object)typePath, (Object)exception);
                    return false;
                }
            }
            fileStream.close();
        }
        return bl;
    }

    private static boolean fileNameMatchesType(Path innerFile) {
        Objects.requireNonNull(innerFile);
        String fileName = innerFile.getFileName().toString();
        return FHIR_TYPE_NAMES.stream().anyMatch(type -> fileName.toLowerCase().startsWith((String)type));
    }

    private static boolean matchesAnyResourceType(Path innerFile) {
        return FHIR_TYPE_NAMES.contains(innerFile.getFileName().toString().toLowerCase());
    }

    @Nonnull
    private static Stream<Path> listFiles(Path innerPath) {
        try {
            return Files.list(innerPath);
        }
        catch (IOException e) {
            logger.error("Error listing files in path: {}", (Object)innerPath, (Object)e);
            return Stream.empty();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean contentsMatchClaimedType(Path filePath, Enumerations.FHIRAllTypes claimedFhirType) {
        Objects.requireNonNull(filePath);
        Objects.requireNonNull(claimedFhirType);
        try (Stream<String> linesStream = Files.lines(filePath, StandardCharsets.UTF_8);){
            String contents = linesStream.collect(Collectors.joining());
            if (contents.isEmpty()) {
                boolean bl2 = false;
                return bl2;
            }
            String filename = filePath.getFileName().toString();
            String fileNameWithoutExtension = filename.substring(0, filename.lastIndexOf("."));
            boolean bl = contents.toUpperCase().contains("\"RESOURCETYPE\": \"%s\"".formatted(claimedFhirType.name())) && !contents.toUpperCase().contains("\"ID\": \"%s\"".formatted(fileNameWithoutExtension.toUpperCase()));
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static Enumerations.FHIRAllTypes claimedFhirType(Path filePath) {
        String filename = filePath.getFileName().toString();
        if (!filename.contains("-")) {
            return Enumerations.FHIRAllTypes.NULL;
        }
        String codeName = filename.substring(0, filename.indexOf("-")).toUpperCase();
        try {
            return Enumerations.FHIRAllTypes.valueOf((String)codeName);
        }
        catch (Exception e) {
            return Enumerations.FHIRAllTypes.NULL;
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        IgConventions that = (IgConventions)other;
        return this.typeLayout == that.typeLayout && this.filenameMode == that.filenameMode && this.categoryLayout == that.categoryLayout && this.compartmentLayout == that.compartmentLayout && (this.encodingBehavior != null ? this.encodingBehavior.equals(that.encodingBehavior) : that.encodingBehavior == null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.typeLayout, this.categoryLayout, this.compartmentLayout, this.filenameMode, this.encodingBehavior});
    }

    @Override
    @Nonnull
    public String toString() {
        return "IGConventions [typeLayout=%s, categoryLayout=%s compartmentLayout=%s, filenameMode=%s]".formatted(new Object[]{this.typeLayout, this.categoryLayout, this.compartmentLayout, this.filenameMode});
    }

    public static enum FhirTypeLayout {
        DIRECTORY_PER_TYPE,
        FLAT;

    }

    public static enum CategoryLayout {
        DIRECTORY_PER_CATEGORY,
        DEFINITIONAL_AND_DATA,
        FLAT;

    }

    public static enum CompartmentLayout {
        DIRECTORY_PER_COMPARTMENT,
        FLAT;

    }

    public static enum FilenameMode {
        TYPE_AND_ID,
        ID_ONLY;

    }
}

