/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.repository.operations;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.opencds.cqf.fhir.utility.adapter.IAdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.IParametersAdapter;
import org.opencds.cqf.fhir.utility.adapter.IParametersParameterComponentAdapter;

public class OperationParametersParser {
    protected IAdapterFactory adapterFactory;

    public OperationParametersParser(IAdapterFactory adapterFactory) {
        Objects.requireNonNull(adapterFactory, "adapterFactory must not be null");
        this.adapterFactory = adapterFactory;
    }

    public void addResourceChild(IBaseParameters parameters, String name, IBaseResource resource) {
        Objects.requireNonNull(parameters, "parameters must not be null");
        Objects.requireNonNull(name, "name must not be null");
        IParametersAdapter parametersAdapter = this.adapterFactory.createParameters(parameters);
        List<IParametersParameterComponentAdapter> parts = parametersAdapter.getParameter();
        IParametersParameterComponentAdapter part = parts.stream().filter(x -> x.getName().equals(name)).findFirst().orElse(null);
        if (part == null) {
            part = this.adapterFactory.createParametersParameter((IBase)parametersAdapter.addParameter());
        }
        part.setName(name);
        part.setResource(resource);
        part.setValue(null);
    }

    public void addValueChild(IBaseParameters parameters, String name, IBaseDatatype value) {
        Objects.requireNonNull(parameters, "parameters must not be null");
        Objects.requireNonNull(name, "name must not be null");
        IParametersAdapter parametersAdapter = this.adapterFactory.createParameters(parameters);
        List<IParametersParameterComponentAdapter> parts = parametersAdapter.getParameter();
        IParametersParameterComponentAdapter part = parts.stream().filter(x -> x.getName().equals(name)).findFirst().orElse(null);
        if (part == null) {
            part = this.adapterFactory.createParametersParameter((IBase)parametersAdapter.addParameter());
        }
        part.setName(name);
        part.setResource(null);
        part.setValue(value);
    }

    public IBaseResource getResourceChild(IBaseParameters parameters, String name) {
        if (parameters == null) {
            return null;
        }
        Objects.requireNonNull(name, "name must not be null");
        IParametersAdapter parametersAdapter = this.adapterFactory.createParameters(parameters);
        return parametersAdapter.getParameter().stream().filter(x -> x.getName().equals(name)).map(IParametersParameterComponentAdapter::getResource).findFirst().orElse(null);
    }

    public Map<String, IBaseResource> getResourceChildren(IBaseParameters parameters) {
        if (parameters == null) {
            return null;
        }
        Objects.requireNonNull(parameters, "parameters must not be null");
        IParametersAdapter parametersAdapter = this.adapterFactory.createParameters(parameters);
        return parametersAdapter.getParameter().stream().collect(Collectors.toMap(IParametersParameterComponentAdapter::getName, IParametersParameterComponentAdapter::getResource));
    }

    public IBaseDatatype getValueChild(IBaseParameters parameters, String name) {
        if (parameters == null) {
            return null;
        }
        Objects.requireNonNull(parameters, "parameters must not be null");
        Objects.requireNonNull(name, "name must not be null");
        IParametersAdapter parametersAdapter = this.adapterFactory.createParameters(parameters);
        return parametersAdapter.getParameter().stream().filter(x -> x.getName().equals(name)).map(IParametersParameterComponentAdapter::getValue).findFirst().orElse(null);
    }

    public Map<String, IBaseDatatype> getValueChildren(IBaseParameters parameters) {
        if (parameters == null) {
            return null;
        }
        Objects.requireNonNull(parameters, "parameters must not be null");
        IParametersAdapter parametersAdapter = this.adapterFactory.createParameters(parameters);
        return parametersAdapter.getParameter().stream().collect(Collectors.toMap(IParametersParameterComponentAdapter::getName, IParametersParameterComponentAdapter::getValue));
    }

    public Map<String, Object> getParameterParts(IBaseParameters parameters) {
        Objects.requireNonNull(parameters, "parameters must not be null");
        IParametersAdapter parametersAdapter = this.adapterFactory.createParameters(parameters);
        List<IParametersParameterComponentAdapter> parts = parametersAdapter.getParameter();
        HashMap<String, Object> parameterParts = new HashMap<String, Object>();
        for (IParametersParameterComponentAdapter part : parts) {
            Object value = part.hasValue() ? part.getValue() : (part.hasResource() ? part.getResource() : null);
            if (value == null) continue;
            if (!parameterParts.containsKey(part.getName())) {
                parameterParts.put(part.getName(), value);
                continue;
            }
            Object existingValue = parameterParts.get(part.getName());
            if (existingValue instanceof List) {
                ((List)existingValue).add(value);
                parameterParts.put(part.getName(), existingValue);
                continue;
            }
            List<Object> newListValue = Arrays.asList(existingValue, value);
            parameterParts.put(part.getName(), newListValue);
        }
        return parameterParts;
    }
}

