/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.search;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.TokenParamModifier;
import ca.uhn.fhir.rest.param.UriParam;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opencds.cqf.fhir.utility.Canonicals;

public class Searches {
    public static final Map<String, List<IQueryParameterType>> ALL = Collections.emptyMap();
    private static final String PATIENT = "patient";
    private static final String ACTOR = "actor";
    private static final String SUBJECT = "subject";
    private static final String MEDICATION_STATEMENT = "MedicationStatement";
    private static final String MEDICATION_REQUEST = "MedicationRequest";
    private static final String MEDICATION_DISPENSE = "MedicationDispense";
    private static final String MEDICATION_ADMINISTRATION = "MedicationAdministration";
    private static final String PROCEDURE_REQUEST = "ProcedureRequest";

    private Searches() {
    }

    public static SearchBuilder builder() {
        return new SearchBuilder();
    }

    public static Map<String, List<IQueryParameterType>> byId(String ... ids) {
        Multimap<String, List<IQueryParameterType>> multimap = Searches.builder().withTokenParam("_id", ids).build();
        return Searches.toFlattenedMap(multimap);
    }

    public static Map<String, List<IQueryParameterType>> byId(String id) {
        Multimap<String, List<IQueryParameterType>> multimap = Searches.builder().withTokenParam("_id", id).build();
        return Searches.toFlattenedMap(multimap);
    }

    public static Map<String, List<IQueryParameterType>> byProfile(String profile) {
        Multimap<String, List<IQueryParameterType>> multimap = Searches.builder().withProfile(profile).build();
        return Searches.toFlattenedMap(multimap);
    }

    public static Map<String, List<IQueryParameterType>> byCanonical(String canonical) {
        Canonicals.CanonicalParts parts = Canonicals.getParts(canonical);
        if (parts.version() != null) {
            return Searches.byUrlAndVersion(parts.url(), parts.version());
        }
        return Searches.byUrl(parts.url());
    }

    public static Map<String, List<IQueryParameterType>> byCodeAndSystem(String code, String system) {
        Multimap<String, List<IQueryParameterType>> multimap = Searches.builder().withTokenParam("code", code, system).build();
        return Searches.toFlattenedMap(multimap);
    }

    public static Map<String, List<IQueryParameterType>> byUrl(String url) {
        Multimap<String, List<IQueryParameterType>> multimap = Searches.builder().withUriParam("url", url).build();
        return Searches.toFlattenedMap(multimap);
    }

    public static Map<String, List<IQueryParameterType>> byUrlAndVersion(String url, String version) {
        Multimap<String, List<IQueryParameterType>> multimap = Searches.builder().withUriParam("url", url).withTokenParam("version", version).build();
        return Searches.toFlattenedMap(multimap);
    }

    public static Map<String, List<IQueryParameterType>> byName(String name) {
        Multimap<String, List<IQueryParameterType>> multimap = Searches.builder().withStringParam("name", name).build();
        return Searches.toFlattenedMap(multimap);
    }

    public static Map<String, List<IQueryParameterType>> byStatus(String status) {
        Multimap<String, List<IQueryParameterType>> multimap = Searches.builder().withTokenParam("status", status).build();
        return Searches.toFlattenedMap(multimap);
    }

    public static Map<String, List<IQueryParameterType>> exceptStatus(String status) {
        Multimap<String, List<IQueryParameterType>> multimap = Searches.builder().withModifiedTokenParam("status", TokenParamModifier.NOT, status).build();
        return Searches.toFlattenedMap(multimap);
    }

    public static Map<String, List<IQueryParameterType>> byNameAndVersion(String name, String version) {
        Multimap<String, List<IQueryParameterType>> multimap = version == null || version.isEmpty() ? Searches.builder().withStringParam("name", name).build() : Searches.builder().withStringParam("name", name).withTokenParam("version", version).build();
        return Searches.toFlattenedMap(multimap);
    }

    public static Map<String, List<IQueryParameterType>> toFlattenedMap(Multimap<String, List<IQueryParameterType>> mm) {
        HashMap<String, List<IQueryParameterType>> result = new HashMap<String, List<IQueryParameterType>>();
        mm.asMap().forEach((key, listOfLists) -> {
            List merged = listOfLists.stream().filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
            result.put((String)key, merged);
        });
        return result;
    }

    public static String getPatientSearchParam(FhirVersionEnum fhirVersion, String dataType) {
        if (fhirVersion.equals((Object)FhirVersionEnum.DSTU3)) {
            return switch (dataType) {
                case "Group" -> "member";
                case "Patient" -> "_id";
                case "ResearchSubject" -> "individual";
                case "Appointment", "AppointmentResponse", "Schedule" -> ACTOR;
                case "Account", "AdverseEvent", "ChargeItem", "ClinicalImpression", "Communication", "CommunicationRequest", "Composition", "DeviceUseStatement", "DiagnosticReport", "DocumentManifest", "DocumentReference", "DeviceRequest", "EnrollmentRequest", "SupplyRequest", "Specimen", "RiskAssessment", "RequestGroup", "QuestionnaireResponse", "Observation", MEDICATION_STATEMENT, MEDICATION_REQUEST, "Media", "List" -> SUBJECT;
                case "AllergyIntolerance", "AuditEvent", "Basic", "BodySite", "CarePlan", "CareTeam", "Claim", "ClaimResponse", "Condition", "Consent", "Coverage", "DetectedIssue", "EligibilityRequest", "Encounter", "EpisodeOfCare", "ExplanationOfBenefit", "FamilyMemberHistory", "Flag", "Goal", "ImagingManifest", "ImagingStudy", "Immunization", "ImmunizationRecommendation", "VisionPrescription", "SupplyDelivery", "RelatedPerson", "ReferralRequest", "Provenance", PROCEDURE_REQUEST, "Procedure", "Person", "NutritionOrder", MEDICATION_DISPENSE, MEDICATION_ADMINISTRATION, "MeasureReport" -> PATIENT;
                default -> null;
            };
        }
        return switch (dataType) {
            case "Coverage" -> "policy-holder";
            case "Group" -> "member";
            case "Patient" -> "_id";
            case "ResearchSubject" -> "individual";
            case "Appointment", "AppointmentResponse", "Schedule" -> ACTOR;
            case "Account", "AdverseEvent", "ChargeItem", "ClinicalImpression", "Communication", "CommunicationRequest", "Composition", "DeviceRequest", "DeviceUseStatement", "DiagnosticReport", "DocumentManifest", "DocumentReference", "EnrollmentRequest", "Invoice", "List", "Media", MEDICATION_REQUEST, MEDICATION_STATEMENT, "QuestionnaireResponse", "Observation", "RequestGroup", "RiskAssessment", "SupplyRequest", "Specimen", "RequestOrchestration" -> SUBJECT;
            case "AllergyIntolerance", "AuditEvent", "Basic", "BodyStructure", "CarePlan", "CareTeam", "Claim", "ClaimResponse", "Condition", "Consent", "DetectedIssue", "Encounter", "EpisodeOfCare", "ExplanationOfBenefit", "FamilyMemberHistory", "Flag", "Goal", "ImagingStudy", "Immunization", "ImmunizationRecommendation", "MeasureReport", MEDICATION_ADMINISTRATION, MEDICATION_DISPENSE, "MolecularSequence", "NutritionOrder", "Person", "Procedure", "Provenance", "RelatedPerson", "ServiceRequest", "SupplyDelivery", "VisionPrescription" -> PATIENT;
            default -> null;
        };
    }

    public static class SearchBuilder {
        private Multimap<String, List<IQueryParameterType>> values;

        public Multimap<String, List<IQueryParameterType>> build() {
            return this.values;
        }

        public Multimap<String, List<IQueryParameterType>> getValues() {
            if (this.values == null) {
                this.values = ArrayListMultimap.create();
            }
            return this.values;
        }

        public SearchBuilder withStringParam(String name, String value) {
            this.getValues().put((Object)name, Collections.singletonList(new StringParam(value)));
            return this;
        }

        public SearchBuilder withTokenParam(String name, String value) {
            this.getValues().put((Object)name, Collections.singletonList(new TokenParam(value)));
            return this;
        }

        public SearchBuilder withModifiedTokenParam(String name, TokenParamModifier modifier, String value) {
            TokenParam token = new TokenParam(value);
            token.setModifier(modifier);
            this.getValues().put((Object)name, Collections.singletonList(token));
            return this;
        }

        public SearchBuilder withTokenParam(String name, String value, String system) {
            this.getValues().put((Object)name, Collections.singletonList(new TokenParam(system, value)));
            return this;
        }

        public SearchBuilder withUriParam(String name, String value) {
            this.getValues().put((Object)name, Collections.singletonList(new UriParam(value)));
            return this;
        }

        SearchBuilder withTokenParam(String name, String ... values) {
            ArrayList<TokenParam> params = new ArrayList<TokenParam>(1 + values.length);
            for (String v : values) {
                params.add(new TokenParam(v));
            }
            this.getValues().put((Object)name, params);
            return this;
        }

        public SearchBuilder withReferenceParam(String spName, String referenceValue) {
            this.getValues().put((Object)spName, Collections.singletonList(new ReferenceParam(referenceValue)));
            return this;
        }

        public SearchBuilder withProfile(String profile) {
            return this.withUriParam("_profile", profile);
        }

        public SearchBuilder withAndListParam(String spName, IQueryParameterAnd<?> andListParam) {
            Collection lists = this.getValues().get((Object)spName);
            andListParam.getValuesAsQueryTokens().forEach(dateOrListParam -> {
                List list = dateOrListParam.getValuesAsQueryTokens();
                lists.add(list);
            });
            return this;
        }

        public SearchBuilder withOrListParam(String spName, IQueryParameterOr<?> orListParam) {
            List qpList = orListParam.getValuesAsQueryTokens();
            this.getValues().get((Object)spName).add(qpList);
            return this;
        }
    }
}

