/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.r5;

import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.adapter.DependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.IDependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.KnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.adapter.r5.ResourceAdapter;
import org.opencds.cqf.fhir.utility.visitor.KnowledgeArtifactVisitor;

public class PlanDefinitionAdapter
extends ResourceAdapter
implements KnowledgeArtifactAdapter {
    private PlanDefinition planDefinition;

    public PlanDefinitionAdapter(IDomainResource planDefinition) {
        super((IBaseResource)planDefinition);
        if (!(planDefinition instanceof PlanDefinition)) {
            throw new IllegalArgumentException("resource passed as planDefinition argument is not a PlanDefinition resource");
        }
        this.planDefinition = (PlanDefinition)planDefinition;
    }

    @Override
    public IBase accept(KnowledgeArtifactVisitor visitor, Repository repository, IBaseParameters operationParameters) {
        return visitor.visit(this, repository, operationParameters);
    }

    protected PlanDefinition getPlanDefinition() {
        return this.planDefinition;
    }

    @Override
    public PlanDefinition get() {
        return this.planDefinition;
    }

    public PlanDefinition copy() {
        return this.get().copy();
    }

    @Override
    public IIdType getId() {
        return this.getPlanDefinition().getIdElement();
    }

    @Override
    public void setId(IIdType id) {
        this.getPlanDefinition().setId(id);
    }

    @Override
    public String getName() {
        return this.getPlanDefinition().getName();
    }

    @Override
    public String getPurpose() {
        return this.getPlanDefinition().getPurpose();
    }

    @Override
    public void setName(String name) {
        this.getPlanDefinition().setName(name);
    }

    @Override
    public String getUrl() {
        return this.getPlanDefinition().getUrl();
    }

    @Override
    public boolean hasUrl() {
        return this.getPlanDefinition().hasUrl();
    }

    @Override
    public void setUrl(String url) {
        this.getPlanDefinition().setUrl(url);
    }

    @Override
    public String getVersion() {
        return this.getPlanDefinition().getVersion();
    }

    @Override
    public boolean hasVersion() {
        return this.getPlanDefinition().hasVersion();
    }

    @Override
    public void setVersion(String version) {
        this.getPlanDefinition().setVersion(version);
    }

    @Override
    public List<IDependencyInfo> getDependencies() {
        ArrayList<IDependencyInfo> references = new ArrayList<IDependencyInfo>();
        String referenceSource = this.getPlanDefinition().hasVersion() ? this.getPlanDefinition().getUrl() + "|" + this.getPlanDefinition().getVersion() : this.getPlanDefinition().getUrl();
        references.addAll(this.getRelatedArtifact().stream().map(ra -> DependencyInfo.convertRelatedArtifact((ICompositeType)ra, referenceSource)).collect(Collectors.toList()));
        List libraries = this.getPlanDefinition().getLibrary();
        for (CanonicalType ct : libraries) {
            DependencyInfo dependency = new DependencyInfo(referenceSource, (String)ct.getValue(), ct.getExtension(), reference -> ct.setValue(reference));
            references.add(dependency);
        }
        this.planDefinition.getAction().forEach(action -> this.getDependenciesOfAction((PlanDefinition.PlanDefinitionActionComponent)action, (List<IDependencyInfo>)references, referenceSource));
        this.getPlanDefinition().getExtension().stream().filter(ext -> ext.getUrl().contains("cpg-partOf")).filter(ext -> ext.hasValue()).findAny().ifPresent(ext -> references.add(new DependencyInfo(referenceSource, (String)((CanonicalType)ext.getValue()).getValue(), ext.getExtension(), reference -> ext.setValue((DataType)new CanonicalType(reference)))));
        return references;
    }

    private void getDependenciesOfAction(PlanDefinition.PlanDefinitionActionComponent action, List<IDependencyInfo> references, String referenceSource) {
        action.getTrigger().stream().flatMap(t -> t.getData().stream()).forEach(eventData -> {
            eventData.getProfile().stream().filter(profile -> profile.hasValue()).forEach(profile -> references.add(new DependencyInfo(referenceSource, (String)profile.getValue(), profile.getExtension(), reference -> profile.setValue(reference))));
            eventData.getCodeFilter().stream().filter(cf -> cf.hasValueSet()).forEach(cf -> references.add(new DependencyInfo(referenceSource, cf.getValueSet(), cf.getExtension(), reference -> cf.setValueSet(reference))));
        });
        action.getCondition().stream().filter(c -> c.hasExpression()).map(c -> c.getExpression()).filter(e -> e.hasReference()).forEach(expression -> references.add(new DependencyInfo(referenceSource, expression.getReference(), expression.getExtension(), reference -> expression.setReference(reference))));
        action.getDynamicValue().stream().filter(dv -> dv.hasExpression()).map(dv -> dv.getExpression()).filter(e -> e.hasReference()).forEach(expression -> references.add(new DependencyInfo(referenceSource, expression.getReference(), expression.getExtension(), reference -> expression.setReference(reference))));
        Stream.concat(action.getInput().stream().map(i -> i.getRequirement()), action.getOutput().stream().map(o -> o.getRequirement())).forEach(inputOrOutput -> {
            inputOrOutput.getProfile().stream().filter(profile -> profile.hasValue()).forEach(profile -> references.add(new DependencyInfo(referenceSource, (String)profile.getValue(), profile.getExtension(), reference -> profile.setValue(reference))));
            inputOrOutput.getCodeFilter().stream().filter(cf -> cf.hasValueSet()).forEach(cf -> references.add(new DependencyInfo(referenceSource, cf.getValueSet(), cf.getExtension(), reference -> cf.setValueSet(reference))));
        });
        CanonicalType definition = action.getDefinitionCanonicalType();
        if (definition != null && definition.hasValue()) {
            references.add(new DependencyInfo(referenceSource, (String)definition.getValue(), definition.getExtension(), reference -> definition.setValue(reference)));
        }
        action.getAction().forEach(nestedAction -> this.getDependenciesOfAction((PlanDefinition.PlanDefinitionActionComponent)nestedAction, references, referenceSource));
    }

    @Override
    public Date getApprovalDate() {
        return this.getPlanDefinition().getApprovalDate();
    }

    @Override
    public Date getDate() {
        return this.getPlanDefinition().getDate();
    }

    @Override
    public void setDate(Date date) {
        this.getPlanDefinition().setDate(date);
    }

    @Override
    public void setDateElement(IPrimitiveType<Date> date) {
        if (date != null && !(date instanceof DateTimeType)) {
            throw new UnprocessableEntityException("Date must be " + DateTimeType.class.getName());
        }
        this.getPlanDefinition().setDateElement((DateTimeType)date);
    }

    public Period getEffectivePeriod() {
        return this.getPlanDefinition().getEffectivePeriod();
    }

    @Override
    public void setApprovalDate(Date date) {
        this.getPlanDefinition().setApprovalDate(date);
    }

    @Override
    public boolean hasRelatedArtifact() {
        return this.getPlanDefinition().hasRelatedArtifact();
    }

    public List<RelatedArtifact> getRelatedArtifact() {
        return this.getPlanDefinition().getRelatedArtifact();
    }

    @Override
    public <T extends ICompositeType & IBaseHasExtensions> void setRelatedArtifact(List<T> relatedArtifacts) {
        this.getPlanDefinition().setRelatedArtifact(relatedArtifacts.stream().map(ra -> (RelatedArtifact)ra).collect(Collectors.toList()));
    }

    public List<RelatedArtifact> getRelatedArtifactsOfType(String codeString) {
        RelatedArtifact.RelatedArtifactType type;
        try {
            type = RelatedArtifact.RelatedArtifactType.fromCode((String)codeString);
        }
        catch (FHIRException e) {
            throw new UnprocessableEntityException("Invalid related artifact code");
        }
        return this.getRelatedArtifact().stream().filter(ra -> ra.getType() == type).collect(Collectors.toList());
    }

    @Override
    public void setEffectivePeriod(ICompositeType effectivePeriod) {
        if (effectivePeriod != null && !(effectivePeriod instanceof Period)) {
            throw new UnprocessableEntityException("EffectivePeriod must be org.hl7.fhir.r5.model.Period");
        }
        this.getPlanDefinition().setEffectivePeriod((Period)effectivePeriod);
    }

    @Override
    public void setStatus(String statusCodeString) {
        Enumerations.PublicationStatus status;
        try {
            status = Enumerations.PublicationStatus.fromCode((String)statusCodeString);
        }
        catch (FHIRException e) {
            throw new UnprocessableEntityException("Invalid status code");
        }
        this.getPlanDefinition().setStatus(status);
    }

    @Override
    public String getStatus() {
        return this.getPlanDefinition().getStatus() == null ? null : this.getPlanDefinition().getStatus().toCode();
    }

    @Override
    public boolean getExperimental() {
        return this.getPlanDefinition().getExperimental();
    }

    @Override
    public void setExtension(List<IBaseExtension<?, ?>> extensions) {
        this.get().setExtension(extensions.stream().map(e -> (Extension)e).collect(Collectors.toList()));
    }
}

