/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.client;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.gclient.IOperationUnnamed;
import java.util.Objects;
import org.hl7.fhir.dstu3.model.Parameters;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.StringType;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.client.Clients;

public class TerminologyServerClient {
    private final FhirContext ctx;

    public TerminologyServerClient(FhirContext ctx) {
        this.ctx = ctx;
    }

    public ValueSet expand(ValueSet valueSet, String authoritativeSource, Parameters expansionParameters, String username, String apiKey) {
        IGenericClient fhirClient = this.ctx.newRestfulGenericClient(this.getAuthoritativeSourceBase(authoritativeSource));
        Clients.registerAdditionalRequestHeadersAuth(fhirClient, username, apiKey);
        if (expansionParameters == null) {
            expansionParameters = new Parameters();
        }
        if (!expansionParameters.getParameter().stream().anyMatch(p -> p.getName().equals("url"))) {
            expansionParameters.addParameter().setName("url").setValue((org.hl7.fhir.dstu3.model.Type)new UriType(valueSet.getUrl()));
        }
        if (valueSet.hasVersion() && !expansionParameters.getParameter().stream().anyMatch(p -> p.getName().equals("valueSetVersion"))) {
            expansionParameters.addParameter().setName("valueSetVersion").setValue((org.hl7.fhir.dstu3.model.Type)new org.hl7.fhir.dstu3.model.StringType(valueSet.getVersion()));
        }
        return (ValueSet)((IOperationUnnamed)fhirClient.operation().onType("ValueSet")).named("$expand").withParameters((IBaseParameters)expansionParameters).returnResourceType(ValueSet.class).execute();
    }

    public org.hl7.fhir.r4.model.ValueSet expand(org.hl7.fhir.r4.model.ValueSet valueSet, String authoritativeSource, org.hl7.fhir.r4.model.Parameters expansionParameters, String username, String apiKey) {
        IGenericClient fhirClient = this.ctx.newRestfulGenericClient(this.getAuthoritativeSourceBase(authoritativeSource));
        Clients.registerAdditionalRequestHeadersAuth(fhirClient, username, apiKey);
        if (expansionParameters == null) {
            expansionParameters = new org.hl7.fhir.r4.model.Parameters();
        }
        if (!expansionParameters.hasParameter("url")) {
            expansionParameters.addParameter("url", (Type)new org.hl7.fhir.r4.model.UriType(valueSet.getUrl()));
        }
        if (valueSet.hasVersion() && !expansionParameters.hasParameter("valueSetVersion")) {
            expansionParameters.addParameter("valueSetVersion", (Type)new org.hl7.fhir.r4.model.StringType(valueSet.getVersion()));
        }
        return (org.hl7.fhir.r4.model.ValueSet)((IOperationUnnamed)fhirClient.operation().onType("ValueSet")).named("$expand").withParameters((IBaseParameters)expansionParameters).returnResourceType(org.hl7.fhir.r4.model.ValueSet.class).execute();
    }

    public org.hl7.fhir.r5.model.ValueSet expand(org.hl7.fhir.r5.model.ValueSet valueSet, String authoritativeSource, org.hl7.fhir.r5.model.Parameters expansionParameters, String username, String apiKey) {
        IGenericClient fhirClient = this.ctx.newRestfulGenericClient(this.getAuthoritativeSourceBase(authoritativeSource));
        Clients.registerAdditionalRequestHeadersAuth(fhirClient, username, apiKey);
        if (expansionParameters == null) {
            expansionParameters = new org.hl7.fhir.r5.model.Parameters();
        }
        if (!expansionParameters.hasParameter("url")) {
            expansionParameters.addParameter("url", (DataType)new org.hl7.fhir.r5.model.UriType(valueSet.getUrl()));
        }
        if (valueSet.hasVersion() && !expansionParameters.hasParameter("valueSetVersion")) {
            expansionParameters.addParameter("valueSetVersion", (DataType)new StringType(valueSet.getVersion()));
        }
        return (org.hl7.fhir.r5.model.ValueSet)((IOperationUnnamed)fhirClient.operation().onType("ValueSet")).named("$expand").withParameters((IBaseParameters)expansionParameters).returnResourceType(org.hl7.fhir.r5.model.ValueSet.class).execute();
    }

    private String getAuthoritativeSourceBase(String authoritativeSource) {
        if ((authoritativeSource = authoritativeSource.substring(0, authoritativeSource.indexOf(Objects.requireNonNull(Canonicals.getResourceType(authoritativeSource))))).startsWith("http://")) {
            authoritativeSource = authoritativeSource.replaceFirst("http://", "https://");
        }
        return authoritativeSource;
    }
}

